/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.datapipeline.model.DescribeObjectsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeObjectsRequestModelMarshaller {
    private static final MarshallingInfo<String> PIPELINEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pipelineId").isBinary(false).build();
    private static final MarshallingInfo<List> OBJECTIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("objectIds").isBinary(false).build();
    private static final MarshallingInfo<Boolean> EVALUATEEXPRESSIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("evaluateExpressions").isBinary(false).build();
    private static final MarshallingInfo<String> MARKER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("marker").isBinary(false).build();
    private static final DescribeObjectsRequestModelMarshaller INSTANCE = new DescribeObjectsRequestModelMarshaller();

    private DescribeObjectsRequestModelMarshaller() {
    }

    public static DescribeObjectsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DescribeObjectsRequest describeObjectsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)describeObjectsRequest), (String)"describeObjectsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)describeObjectsRequest.pipelineId(), PIPELINEID_BINDING);
            protocolMarshaller.marshall(describeObjectsRequest.objectIds(), OBJECTIDS_BINDING);
            protocolMarshaller.marshall((Object)describeObjectsRequest.evaluateExpressions(), EVALUATEEXPRESSIONS_BINDING);
            protocolMarshaller.marshall((Object)describeObjectsRequest.marker(), MARKER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

