/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.datapipeline.model.InstanceIdentity;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InstanceIdentityMarshaller {
    private static final MarshallingInfo<String> DOCUMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("document").isBinary(false).build();
    private static final MarshallingInfo<String> SIGNATURE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("signature").isBinary(false).build();
    private static final InstanceIdentityMarshaller INSTANCE = new InstanceIdentityMarshaller();

    private InstanceIdentityMarshaller() {
    }

    public static InstanceIdentityMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InstanceIdentity instanceIdentity, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)instanceIdentity, (String)"instanceIdentity");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)instanceIdentity.document(), DOCUMENT_BINDING);
            protocolMarshaller.marshall((Object)instanceIdentity.signature(), SIGNATURE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

