/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.datapipeline.model.Field;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class FieldMarshaller {
    private static final MarshallingInfo<String> KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("key").isBinary(false).build();
    private static final MarshallingInfo<String> STRINGVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stringValue").isBinary(false).build();
    private static final MarshallingInfo<String> REFVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("refValue").isBinary(false).build();
    private static final FieldMarshaller INSTANCE = new FieldMarshaller();

    private FieldMarshaller() {
    }

    public static FieldMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Field field, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)field, (String)"field");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)field.key(), KEY_BINDING);
            protocolMarshaller.marshall((Object)field.stringValue(), STRINGVALUE_BINDING);
            protocolMarshaller.marshall((Object)field.refValue(), REFVALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

