/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.datapipeline.model._validationMessagesCopier;
import software.amazon.awssdk.services.datapipeline.transform.ValidationWarningMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ValidationWarning
implements StructuredPojo,
ToCopyableBuilder<Builder, ValidationWarning> {
    private final String id;
    private final List<String> warnings;

    private ValidationWarning(BuilderImpl builder) {
        this.id = builder.id;
        this.warnings = builder.warnings;
    }

    public String id() {
        return this.id;
    }

    public List<String> warnings() {
        return this.warnings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.warnings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidationWarning)) {
            return false;
        }
        ValidationWarning other = (ValidationWarning)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.warnings(), other.warnings());
    }

    public String toString() {
        return ToString.builder((String)"ValidationWarning").add("Id", (Object)this.id()).add("Warnings", this.warnings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "warnings": {
                return Optional.of(clazz.cast(this.warnings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ValidationWarningMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private List<String> warnings;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationWarning model) {
            this.id(model.id);
            this.warnings(model.warnings);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Collection<String> getWarnings() {
            return this.warnings;
        }

        @Override
        public final Builder warnings(Collection<String> warnings) {
            this.warnings = _validationMessagesCopier.copy(warnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(String ... warnings) {
            this.warnings(Arrays.asList(warnings));
            return this;
        }

        public final void setWarnings(Collection<String> warnings) {
            this.warnings = _validationMessagesCopier.copy(warnings);
        }

        public ValidationWarning build() {
            return new ValidationWarning(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ValidationWarning> {
        public Builder id(String var1);

        public Builder warnings(Collection<String> var1);

        public Builder warnings(String ... var1);
    }
}

