/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.datapipeline.model.DataPipelineRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReportTaskRunnerHeartbeatRequest
extends DataPipelineRequest
implements ToCopyableBuilder<Builder, ReportTaskRunnerHeartbeatRequest> {
    private final String taskrunnerId;
    private final String workerGroup;
    private final String hostname;

    private ReportTaskRunnerHeartbeatRequest(BuilderImpl builder) {
        super(builder);
        this.taskrunnerId = builder.taskrunnerId;
        this.workerGroup = builder.workerGroup;
        this.hostname = builder.hostname;
    }

    public String taskrunnerId() {
        return this.taskrunnerId;
    }

    public String workerGroup() {
        return this.workerGroup;
    }

    public String hostname() {
        return this.hostname;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskrunnerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workerGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostname());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportTaskRunnerHeartbeatRequest)) {
            return false;
        }
        ReportTaskRunnerHeartbeatRequest other = (ReportTaskRunnerHeartbeatRequest)((Object)obj);
        return Objects.equals(this.taskrunnerId(), other.taskrunnerId()) && Objects.equals(this.workerGroup(), other.workerGroup()) && Objects.equals(this.hostname(), other.hostname());
    }

    public String toString() {
        return ToString.builder((String)"ReportTaskRunnerHeartbeatRequest").add("TaskrunnerId", (Object)this.taskrunnerId()).add("WorkerGroup", (Object)this.workerGroup()).add("Hostname", (Object)this.hostname()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskrunnerId": {
                return Optional.of(clazz.cast(this.taskrunnerId()));
            }
            case "workerGroup": {
                return Optional.of(clazz.cast(this.workerGroup()));
            }
            case "hostname": {
                return Optional.of(clazz.cast(this.hostname()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DataPipelineRequest.BuilderImpl
    implements Builder {
        private String taskrunnerId;
        private String workerGroup;
        private String hostname;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportTaskRunnerHeartbeatRequest model) {
            super(model);
            this.taskrunnerId(model.taskrunnerId);
            this.workerGroup(model.workerGroup);
            this.hostname(model.hostname);
        }

        public final String getTaskrunnerId() {
            return this.taskrunnerId;
        }

        @Override
        public final Builder taskrunnerId(String taskrunnerId) {
            this.taskrunnerId = taskrunnerId;
            return this;
        }

        public final void setTaskrunnerId(String taskrunnerId) {
            this.taskrunnerId = taskrunnerId;
        }

        public final String getWorkerGroup() {
            return this.workerGroup;
        }

        @Override
        public final Builder workerGroup(String workerGroup) {
            this.workerGroup = workerGroup;
            return this;
        }

        public final void setWorkerGroup(String workerGroup) {
            this.workerGroup = workerGroup;
        }

        public final String getHostname() {
            return this.hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ReportTaskRunnerHeartbeatRequest build() {
            return new ReportTaskRunnerHeartbeatRequest(this);
        }
    }

    public static interface Builder
    extends DataPipelineRequest.Builder,
    CopyableBuilder<Builder, ReportTaskRunnerHeartbeatRequest> {
        public Builder taskrunnerId(String var1);

        public Builder workerGroup(String var1);

        public Builder hostname(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

