/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.datapipeline.model.DataPipelineRequest;
import software.amazon.awssdk.services.datapipeline.model.Query;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class QueryObjectsRequest
extends DataPipelineRequest
implements ToCopyableBuilder<Builder, QueryObjectsRequest> {
    private final String pipelineId;
    private final Query query;
    private final String sphere;
    private final String marker;
    private final Integer limit;

    private QueryObjectsRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineId = builder.pipelineId;
        this.query = builder.query;
        this.sphere = builder.sphere;
        this.marker = builder.marker;
        this.limit = builder.limit;
    }

    public String pipelineId() {
        return this.pipelineId;
    }

    public Query query() {
        return this.query;
    }

    public String sphere() {
        return this.sphere;
    }

    public String marker() {
        return this.marker;
    }

    public Integer limit() {
        return this.limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.query());
        hashCode = 31 * hashCode + Objects.hashCode(this.sphere());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryObjectsRequest)) {
            return false;
        }
        QueryObjectsRequest other = (QueryObjectsRequest)((Object)obj);
        return Objects.equals(this.pipelineId(), other.pipelineId()) && Objects.equals(this.query(), other.query()) && Objects.equals(this.sphere(), other.sphere()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.limit(), other.limit());
    }

    public String toString() {
        return ToString.builder((String)"QueryObjectsRequest").add("PipelineId", (Object)this.pipelineId()).add("Query", (Object)this.query()).add("Sphere", (Object)this.sphere()).add("Marker", (Object)this.marker()).add("Limit", (Object)this.limit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineId": {
                return Optional.of(clazz.cast(this.pipelineId()));
            }
            case "query": {
                return Optional.of(clazz.cast(this.query()));
            }
            case "sphere": {
                return Optional.of(clazz.cast(this.sphere()));
            }
            case "marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "limit": {
                return Optional.of(clazz.cast(this.limit()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DataPipelineRequest.BuilderImpl
    implements Builder {
        private String pipelineId;
        private Query query;
        private String sphere;
        private String marker;
        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryObjectsRequest model) {
            super(model);
            this.pipelineId(model.pipelineId);
            this.query(model.query);
            this.sphere(model.sphere);
            this.marker(model.marker);
            this.limit(model.limit);
        }

        public final String getPipelineId() {
            return this.pipelineId;
        }

        @Override
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        public final Query.Builder getQuery() {
            return this.query != null ? this.query.toBuilder() : null;
        }

        @Override
        public final Builder query(Query query) {
            this.query = query;
            return this;
        }

        public final void setQuery(Query.BuilderImpl query) {
            this.query = query != null ? query.build() : null;
        }

        public final String getSphere() {
            return this.sphere;
        }

        @Override
        public final Builder sphere(String sphere) {
            this.sphere = sphere;
            return this;
        }

        public final void setSphere(String sphere) {
            this.sphere = sphere;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public QueryObjectsRequest build() {
            return new QueryObjectsRequest(this);
        }
    }

    public static interface Builder
    extends DataPipelineRequest.Builder,
    CopyableBuilder<Builder, QueryObjectsRequest> {
        public Builder pipelineId(String var1);

        public Builder query(Query var1);

        default public Builder query(Consumer<Query.Builder> query) {
            return this.query((Query)((Query.Builder)Query.builder().apply(query)).build());
        }

        public Builder sphere(String var1);

        public Builder marker(String var1);

        public Builder limit(Integer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

