/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.datapipeline.model.DataPipelineRequest;
import software.amazon.awssdk.services.datapipeline.model._idListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribePipelinesRequest
extends DataPipelineRequest
implements ToCopyableBuilder<Builder, DescribePipelinesRequest> {
    private final List<String> pipelineIds;

    private DescribePipelinesRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineIds = builder.pipelineIds;
    }

    public List<String> pipelineIds() {
        return this.pipelineIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePipelinesRequest)) {
            return false;
        }
        DescribePipelinesRequest other = (DescribePipelinesRequest)((Object)obj);
        return Objects.equals(this.pipelineIds(), other.pipelineIds());
    }

    public String toString() {
        return ToString.builder((String)"DescribePipelinesRequest").add("PipelineIds", this.pipelineIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineIds": {
                return Optional.of(clazz.cast(this.pipelineIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DataPipelineRequest.BuilderImpl
    implements Builder {
        private List<String> pipelineIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePipelinesRequest model) {
            super(model);
            this.pipelineIds(model.pipelineIds);
        }

        public final Collection<String> getPipelineIds() {
            return this.pipelineIds;
        }

        @Override
        public final Builder pipelineIds(Collection<String> pipelineIds) {
            this.pipelineIds = _idListCopier.copy(pipelineIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineIds(String ... pipelineIds) {
            this.pipelineIds(Arrays.asList(pipelineIds));
            return this;
        }

        public final void setPipelineIds(Collection<String> pipelineIds) {
            this.pipelineIds = _idListCopier.copy(pipelineIds);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribePipelinesRequest build() {
            return new DescribePipelinesRequest(this);
        }
    }

    public static interface Builder
    extends DataPipelineRequest.Builder,
    CopyableBuilder<Builder, DescribePipelinesRequest> {
        public Builder pipelineIds(Collection<String> var1);

        public Builder pipelineIds(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

