/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dataexchange.model.KmsKeyToGrant;
import software.amazon.awssdk.services.dataexchange.model.ListOfKmsKeysToGrantCopier;
import software.amazon.awssdk.services.dataexchange.model.ListOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3DataAccessAssetSourceEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3DataAccessAssetSourceEntry> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Bucket").getter(S3DataAccessAssetSourceEntry.getter(S3DataAccessAssetSourceEntry::bucket)).setter(S3DataAccessAssetSourceEntry.setter(Builder::bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket").build()}).build();
    private static final SdkField<List<String>> KEY_PREFIXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("KeyPrefixes").getter(S3DataAccessAssetSourceEntry.getter(S3DataAccessAssetSourceEntry::keyPrefixes)).setter(S3DataAccessAssetSourceEntry.setter(Builder::keyPrefixes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPrefixes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Keys").getter(S3DataAccessAssetSourceEntry.getter(S3DataAccessAssetSourceEntry::keys)).setter(S3DataAccessAssetSourceEntry.setter(Builder::keys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<KmsKeyToGrant>> KMS_KEYS_TO_GRANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("KmsKeysToGrant").getter(S3DataAccessAssetSourceEntry.getter(S3DataAccessAssetSourceEntry::kmsKeysToGrant)).setter(S3DataAccessAssetSourceEntry.setter(Builder::kmsKeysToGrant)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeysToGrant").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KmsKeyToGrant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD, KEY_PREFIXES_FIELD, KEYS_FIELD, KMS_KEYS_TO_GRANT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3DataAccessAssetSourceEntry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String bucket;
    private final List<String> keyPrefixes;
    private final List<String> keys;
    private final List<KmsKeyToGrant> kmsKeysToGrant;

    private S3DataAccessAssetSourceEntry(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.keyPrefixes = builder.keyPrefixes;
        this.keys = builder.keys;
        this.kmsKeysToGrant = builder.kmsKeysToGrant;
    }

    public final String bucket() {
        return this.bucket;
    }

    public final boolean hasKeyPrefixes() {
        return this.keyPrefixes != null && !(this.keyPrefixes instanceof SdkAutoConstructList);
    }

    public final List<String> keyPrefixes() {
        return this.keyPrefixes;
    }

    public final boolean hasKeys() {
        return this.keys != null && !(this.keys instanceof SdkAutoConstructList);
    }

    public final List<String> keys() {
        return this.keys;
    }

    public final boolean hasKmsKeysToGrant() {
        return this.kmsKeysToGrant != null && !(this.kmsKeysToGrant instanceof SdkAutoConstructList);
    }

    public final List<KmsKeyToGrant> kmsKeysToGrant() {
        return this.kmsKeysToGrant;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeyPrefixes() ? this.keyPrefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeys() ? this.keys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKmsKeysToGrant() ? this.kmsKeysToGrant() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DataAccessAssetSourceEntry)) {
            return false;
        }
        S3DataAccessAssetSourceEntry other = (S3DataAccessAssetSourceEntry)obj;
        return Objects.equals(this.bucket(), other.bucket()) && this.hasKeyPrefixes() == other.hasKeyPrefixes() && Objects.equals(this.keyPrefixes(), other.keyPrefixes()) && this.hasKeys() == other.hasKeys() && Objects.equals(this.keys(), other.keys()) && this.hasKmsKeysToGrant() == other.hasKmsKeysToGrant() && Objects.equals(this.kmsKeysToGrant(), other.kmsKeysToGrant());
    }

    public final String toString() {
        return ToString.builder((String)"S3DataAccessAssetSourceEntry").add("Bucket", (Object)this.bucket()).add("KeyPrefixes", this.hasKeyPrefixes() ? this.keyPrefixes() : null).add("Keys", this.hasKeys() ? this.keys() : null).add("KmsKeysToGrant", this.hasKmsKeysToGrant() ? this.kmsKeysToGrant() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "KeyPrefixes": {
                return Optional.ofNullable(clazz.cast(this.keyPrefixes()));
            }
            case "Keys": {
                return Optional.ofNullable(clazz.cast(this.keys()));
            }
            case "KmsKeysToGrant": {
                return Optional.ofNullable(clazz.cast(this.kmsKeysToGrant()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Bucket", BUCKET_FIELD);
        map.put("KeyPrefixes", KEY_PREFIXES_FIELD);
        map.put("Keys", KEYS_FIELD);
        map.put("KmsKeysToGrant", KMS_KEYS_TO_GRANT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3DataAccessAssetSourceEntry, T> g) {
        return obj -> g.apply((S3DataAccessAssetSourceEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucket;
        private List<String> keyPrefixes = DefaultSdkAutoConstructList.getInstance();
        private List<String> keys = DefaultSdkAutoConstructList.getInstance();
        private List<KmsKeyToGrant> kmsKeysToGrant = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(S3DataAccessAssetSourceEntry model) {
            this.bucket(model.bucket);
            this.keyPrefixes(model.keyPrefixes);
            this.keys(model.keys);
            this.kmsKeysToGrant(model.kmsKeysToGrant);
        }

        public final String getBucket() {
            return this.bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final Collection<String> getKeyPrefixes() {
            if (this.keyPrefixes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.keyPrefixes;
        }

        public final void setKeyPrefixes(Collection<String> keyPrefixes) {
            this.keyPrefixes = ListOf__stringCopier.copy(keyPrefixes);
        }

        @Override
        public final Builder keyPrefixes(Collection<String> keyPrefixes) {
            this.keyPrefixes = ListOf__stringCopier.copy(keyPrefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPrefixes(String ... keyPrefixes) {
            this.keyPrefixes(Arrays.asList(keyPrefixes));
            return this;
        }

        public final Collection<String> getKeys() {
            if (this.keys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.keys;
        }

        public final void setKeys(Collection<String> keys) {
            this.keys = ListOf__stringCopier.copy(keys);
        }

        @Override
        public final Builder keys(Collection<String> keys) {
            this.keys = ListOf__stringCopier.copy(keys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keys(String ... keys) {
            this.keys(Arrays.asList(keys));
            return this;
        }

        public final List<KmsKeyToGrant.Builder> getKmsKeysToGrant() {
            List<KmsKeyToGrant.Builder> result = ListOfKmsKeysToGrantCopier.copyToBuilder(this.kmsKeysToGrant);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKmsKeysToGrant(Collection<KmsKeyToGrant.BuilderImpl> kmsKeysToGrant) {
            this.kmsKeysToGrant = ListOfKmsKeysToGrantCopier.copyFromBuilder(kmsKeysToGrant);
        }

        @Override
        public final Builder kmsKeysToGrant(Collection<KmsKeyToGrant> kmsKeysToGrant) {
            this.kmsKeysToGrant = ListOfKmsKeysToGrantCopier.copy(kmsKeysToGrant);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kmsKeysToGrant(KmsKeyToGrant ... kmsKeysToGrant) {
            this.kmsKeysToGrant(Arrays.asList(kmsKeysToGrant));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kmsKeysToGrant(Consumer<KmsKeyToGrant.Builder> ... kmsKeysToGrant) {
            this.kmsKeysToGrant(Stream.of(kmsKeysToGrant).map(c -> (KmsKeyToGrant)((KmsKeyToGrant.Builder)KmsKeyToGrant.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public S3DataAccessAssetSourceEntry build() {
            return new S3DataAccessAssetSourceEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3DataAccessAssetSourceEntry> {
        public Builder bucket(String var1);

        public Builder keyPrefixes(Collection<String> var1);

        public Builder keyPrefixes(String ... var1);

        public Builder keys(Collection<String> var1);

        public Builder keys(String ... var1);

        public Builder kmsKeysToGrant(Collection<KmsKeyToGrant> var1);

        public Builder kmsKeysToGrant(KmsKeyToGrant ... var1);

        public Builder kmsKeysToGrant(Consumer<KmsKeyToGrant.Builder> ... var1);
    }
}

