/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.dataexchange.DataExchangeClient;
import software.amazon.awssdk.services.dataexchange.internal.UserAgentUtils;
import software.amazon.awssdk.services.dataexchange.model.DataGrantSummaryEntry;
import software.amazon.awssdk.services.dataexchange.model.ListDataGrantsRequest;
import software.amazon.awssdk.services.dataexchange.model.ListDataGrantsResponse;

public class ListDataGrantsIterable
implements SdkIterable<ListDataGrantsResponse> {
    private final DataExchangeClient client;
    private final ListDataGrantsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDataGrantsIterable(DataExchangeClient client, ListDataGrantsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDataGrantsResponseFetcher();
    }

    public Iterator<ListDataGrantsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataGrantSummaryEntry> dataGrantSummaries() {
        Function<ListDataGrantsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataGrantSummaries() != null) {
                return response.dataGrantSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDataGrantsResponseFetcher
    implements SyncPageFetcher<ListDataGrantsResponse> {
        private ListDataGrantsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataGrantsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDataGrantsResponse nextPage(ListDataGrantsResponse previousPage) {
            if (previousPage == null) {
                return ListDataGrantsIterable.this.client.listDataGrants(ListDataGrantsIterable.this.firstRequest);
            }
            return ListDataGrantsIterable.this.client.listDataGrants((ListDataGrantsRequest)((Object)ListDataGrantsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

