/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dataexchange.model.DataUpdateRequestDetails;
import software.amazon.awssdk.services.dataexchange.model.DeprecationRequestDetails;
import software.amazon.awssdk.services.dataexchange.model.SchemaChangeRequestDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NotificationDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NotificationDetails> {
    private static final SdkField<DataUpdateRequestDetails> DATA_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataUpdate").getter(NotificationDetails.getter(NotificationDetails::dataUpdate)).setter(NotificationDetails.setter(Builder::dataUpdate)).constructor(DataUpdateRequestDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataUpdate").build()}).build();
    private static final SdkField<DeprecationRequestDetails> DEPRECATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Deprecation").getter(NotificationDetails.getter(NotificationDetails::deprecation)).setter(NotificationDetails.setter(Builder::deprecation)).constructor(DeprecationRequestDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Deprecation").build()}).build();
    private static final SdkField<SchemaChangeRequestDetails> SCHEMA_CHANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SchemaChange").getter(NotificationDetails.getter(NotificationDetails::schemaChange)).setter(NotificationDetails.setter(Builder::schemaChange)).constructor(SchemaChangeRequestDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaChange").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_UPDATE_FIELD, DEPRECATION_FIELD, SCHEMA_CHANGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DataUpdate", DATA_UPDATE_FIELD);
            this.put("Deprecation", DEPRECATION_FIELD);
            this.put("SchemaChange", SCHEMA_CHANGE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final DataUpdateRequestDetails dataUpdate;
    private final DeprecationRequestDetails deprecation;
    private final SchemaChangeRequestDetails schemaChange;

    private NotificationDetails(BuilderImpl builder) {
        this.dataUpdate = builder.dataUpdate;
        this.deprecation = builder.deprecation;
        this.schemaChange = builder.schemaChange;
    }

    public final DataUpdateRequestDetails dataUpdate() {
        return this.dataUpdate;
    }

    public final DeprecationRequestDetails deprecation() {
        return this.deprecation;
    }

    public final SchemaChangeRequestDetails schemaChange() {
        return this.schemaChange;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.deprecation());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaChange());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationDetails)) {
            return false;
        }
        NotificationDetails other = (NotificationDetails)obj;
        return Objects.equals(this.dataUpdate(), other.dataUpdate()) && Objects.equals(this.deprecation(), other.deprecation()) && Objects.equals(this.schemaChange(), other.schemaChange());
    }

    public final String toString() {
        return ToString.builder((String)"NotificationDetails").add("DataUpdate", (Object)this.dataUpdate()).add("Deprecation", (Object)this.deprecation()).add("SchemaChange", (Object)this.schemaChange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataUpdate": {
                return Optional.ofNullable(clazz.cast(this.dataUpdate()));
            }
            case "Deprecation": {
                return Optional.ofNullable(clazz.cast(this.deprecation()));
            }
            case "SchemaChange": {
                return Optional.ofNullable(clazz.cast(this.schemaChange()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<NotificationDetails, T> g) {
        return obj -> g.apply((NotificationDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DataUpdateRequestDetails dataUpdate;
        private DeprecationRequestDetails deprecation;
        private SchemaChangeRequestDetails schemaChange;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationDetails model) {
            this.dataUpdate(model.dataUpdate);
            this.deprecation(model.deprecation);
            this.schemaChange(model.schemaChange);
        }

        public final DataUpdateRequestDetails.Builder getDataUpdate() {
            return this.dataUpdate != null ? this.dataUpdate.toBuilder() : null;
        }

        public final void setDataUpdate(DataUpdateRequestDetails.BuilderImpl dataUpdate) {
            this.dataUpdate = dataUpdate != null ? dataUpdate.build() : null;
        }

        @Override
        public final Builder dataUpdate(DataUpdateRequestDetails dataUpdate) {
            this.dataUpdate = dataUpdate;
            return this;
        }

        public final DeprecationRequestDetails.Builder getDeprecation() {
            return this.deprecation != null ? this.deprecation.toBuilder() : null;
        }

        public final void setDeprecation(DeprecationRequestDetails.BuilderImpl deprecation) {
            this.deprecation = deprecation != null ? deprecation.build() : null;
        }

        @Override
        public final Builder deprecation(DeprecationRequestDetails deprecation) {
            this.deprecation = deprecation;
            return this;
        }

        public final SchemaChangeRequestDetails.Builder getSchemaChange() {
            return this.schemaChange != null ? this.schemaChange.toBuilder() : null;
        }

        public final void setSchemaChange(SchemaChangeRequestDetails.BuilderImpl schemaChange) {
            this.schemaChange = schemaChange != null ? schemaChange.build() : null;
        }

        @Override
        public final Builder schemaChange(SchemaChangeRequestDetails schemaChange) {
            this.schemaChange = schemaChange;
            return this;
        }

        public NotificationDetails build() {
            return new NotificationDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NotificationDetails> {
        public Builder dataUpdate(DataUpdateRequestDetails var1);

        default public Builder dataUpdate(Consumer<DataUpdateRequestDetails.Builder> dataUpdate) {
            return this.dataUpdate((DataUpdateRequestDetails)((DataUpdateRequestDetails.Builder)DataUpdateRequestDetails.builder().applyMutation(dataUpdate)).build());
        }

        public Builder deprecation(DeprecationRequestDetails var1);

        default public Builder deprecation(Consumer<DeprecationRequestDetails.Builder> deprecation) {
            return this.deprecation((DeprecationRequestDetails)((DeprecationRequestDetails.Builder)DeprecationRequestDetails.builder().applyMutation(deprecation)).build());
        }

        public Builder schemaChange(SchemaChangeRequestDetails var1);

        default public Builder schemaChange(Consumer<SchemaChangeRequestDetails.Builder> schemaChange) {
            return this.schemaChange((SchemaChangeRequestDetails)((SchemaChangeRequestDetails.Builder)SchemaChangeRequestDetails.builder().applyMutation(schemaChange)).build());
        }
    }
}

