/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The source of the Amazon Redshift datashare asset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedshiftDataShareAssetSourceEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<RedshiftDataShareAssetSourceEntry.Builder, RedshiftDataShareAssetSourceEntry> {
    private static final SdkField<String> DATA_SHARE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataShareArn").getter(getter(RedshiftDataShareAssetSourceEntry::dataShareArn))
            .setter(setter(Builder::dataShareArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataShareArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SHARE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dataShareArn;

    private RedshiftDataShareAssetSourceEntry(BuilderImpl builder) {
        this.dataShareArn = builder.dataShareArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the datashare asset.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the datashare asset.
     */
    public final String dataShareArn() {
        return dataShareArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataShareArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftDataShareAssetSourceEntry)) {
            return false;
        }
        RedshiftDataShareAssetSourceEntry other = (RedshiftDataShareAssetSourceEntry) obj;
        return Objects.equals(dataShareArn(), other.dataShareArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RedshiftDataShareAssetSourceEntry").add("DataShareArn", dataShareArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataShareArn":
            return Optional.ofNullable(clazz.cast(dataShareArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RedshiftDataShareAssetSourceEntry, T> g) {
        return obj -> g.apply((RedshiftDataShareAssetSourceEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RedshiftDataShareAssetSourceEntry> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the datashare asset.
         * </p>
         * 
         * @param dataShareArn
         *        The Amazon Resource Name (ARN) of the datashare asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataShareArn(String dataShareArn);
    }

    static final class BuilderImpl implements Builder {
        private String dataShareArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftDataShareAssetSourceEntry model) {
            dataShareArn(model.dataShareArn);
        }

        public final String getDataShareArn() {
            return dataShareArn;
        }

        public final void setDataShareArn(String dataShareArn) {
            this.dataShareArn = dataShareArn;
        }

        @Override
        public final Builder dataShareArn(String dataShareArn) {
            this.dataShareArn = dataShareArn;
            return this;
        }

        @Override
        public RedshiftDataShareAssetSourceEntry build() {
            return new RedshiftDataShareAssetSourceEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
