/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum State {
    WAITING("WAITING"),
    IN_PROGRESS("IN_PROGRESS"),
    ERROR("ERROR"),
    COMPLETED("COMPLETED"),
    CANCELLED("CANCELLED"),
    TIMED_OUT("TIMED_OUT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, State> VALUE_MAP;
    private final String value;

    private State(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static State fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<State> knownValues() {
        EnumSet<State> knownValues = EnumSet.allOf(State.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(State.class, State::toString);
    }
}

