/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dataexchange.model.AssetEntry;
import software.amazon.awssdk.services.dataexchange.model.DataExchangeResponse;
import software.amazon.awssdk.services.dataexchange.model.ListOfAssetEntryCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRevisionAssetsResponse
extends DataExchangeResponse
implements ToCopyableBuilder<Builder, ListRevisionAssetsResponse> {
    private static final SdkField<List<AssetEntry>> ASSETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Assets").getter(ListRevisionAssetsResponse.getter(ListRevisionAssetsResponse::assets)).setter(ListRevisionAssetsResponse.setter(Builder::assets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Assets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRevisionAssetsResponse.getter(ListRevisionAssetsResponse::nextToken)).setter(ListRevisionAssetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSETS_FIELD, NEXT_TOKEN_FIELD));
    private final List<AssetEntry> assets;
    private final String nextToken;

    private ListRevisionAssetsResponse(BuilderImpl builder) {
        super(builder);
        this.assets = builder.assets;
        this.nextToken = builder.nextToken;
    }

    public boolean hasAssets() {
        return this.assets != null && !(this.assets instanceof SdkAutoConstructList);
    }

    public List<AssetEntry> assets() {
        return this.assets;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssets() ? this.assets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRevisionAssetsResponse)) {
            return false;
        }
        ListRevisionAssetsResponse other = (ListRevisionAssetsResponse)((Object)obj);
        return this.hasAssets() == other.hasAssets() && Objects.equals(this.assets(), other.assets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListRevisionAssetsResponse").add("Assets", this.hasAssets() ? this.assets() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Assets": {
                return Optional.ofNullable(clazz.cast(this.assets()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRevisionAssetsResponse, T> g) {
        return obj -> g.apply((ListRevisionAssetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataExchangeResponse.BuilderImpl
    implements Builder {
        private List<AssetEntry> assets = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRevisionAssetsResponse model) {
            super(model);
            this.assets(model.assets);
            this.nextToken(model.nextToken);
        }

        public final Collection<AssetEntry.Builder> getAssets() {
            if (this.assets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.assets != null ? (Collection)this.assets.stream().map(AssetEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder assets(Collection<AssetEntry> assets) {
            this.assets = ListOfAssetEntryCopier.copy(assets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assets(AssetEntry ... assets) {
            this.assets(Arrays.asList(assets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assets(Consumer<AssetEntry.Builder> ... assets) {
            this.assets(Stream.of(assets).map(c -> (AssetEntry)((AssetEntry.Builder)AssetEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAssets(Collection<AssetEntry.BuilderImpl> assets) {
            this.assets = ListOfAssetEntryCopier.copyFromBuilder(assets);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListRevisionAssetsResponse build() {
            return new ListRevisionAssetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataExchangeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRevisionAssetsResponse> {
        public Builder assets(Collection<AssetEntry> var1);

        public Builder assets(AssetEntry ... var1);

        public Builder assets(Consumer<AssetEntry.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

