/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AssetType {
    S3_SNAPSHOT("S3_SNAPSHOT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AssetType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AssetType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AssetType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AssetType> knownValues() {
        return Stream.of(AssetType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

