/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dataexchange.model.DataExchangeResponse;
import software.amazon.awssdk.services.dataexchange.model.DataSetEntry;
import software.amazon.awssdk.services.dataexchange.model.ListOfDataSetEntryCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDataSetsResponse
extends DataExchangeResponse
implements ToCopyableBuilder<Builder, ListDataSetsResponse> {
    private static final SdkField<List<DataSetEntry>> DATA_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListDataSetsResponse.getter(ListDataSetsResponse::dataSets)).setter(ListDataSetsResponse.setter(Builder::dataSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSetEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListDataSetsResponse.getter(ListDataSetsResponse::nextToken)).setter(ListDataSetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SETS_FIELD, NEXT_TOKEN_FIELD));
    private final List<DataSetEntry> dataSets;
    private final String nextToken;

    private ListDataSetsResponse(BuilderImpl builder) {
        super(builder);
        this.dataSets = builder.dataSets;
        this.nextToken = builder.nextToken;
    }

    public boolean hasDataSets() {
        return this.dataSets != null && !(this.dataSets instanceof SdkAutoConstructList);
    }

    public List<DataSetEntry> dataSets() {
        return this.dataSets;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSets());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataSetsResponse)) {
            return false;
        }
        ListDataSetsResponse other = (ListDataSetsResponse)((Object)obj);
        return Objects.equals(this.dataSets(), other.dataSets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDataSetsResponse").add("DataSets", this.dataSets()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSets": {
                return Optional.ofNullable(clazz.cast(this.dataSets()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDataSetsResponse, T> g) {
        return obj -> g.apply((ListDataSetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataExchangeResponse.BuilderImpl
    implements Builder {
        private List<DataSetEntry> dataSets = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataSetsResponse model) {
            super(model);
            this.dataSets(model.dataSets);
            this.nextToken(model.nextToken);
        }

        public final Collection<DataSetEntry.Builder> getDataSets() {
            return this.dataSets != null ? (Collection)this.dataSets.stream().map(DataSetEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dataSets(Collection<DataSetEntry> dataSets) {
            this.dataSets = ListOfDataSetEntryCopier.copy(dataSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSets(DataSetEntry ... dataSets) {
            this.dataSets(Arrays.asList(dataSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSets(Consumer<DataSetEntry.Builder> ... dataSets) {
            this.dataSets(Stream.of(dataSets).map(c -> (DataSetEntry)((DataSetEntry.Builder)DataSetEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDataSets(Collection<DataSetEntry.BuilderImpl> dataSets) {
            this.dataSets = ListOfDataSetEntryCopier.copyFromBuilder(dataSets);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDataSetsResponse build() {
            return new ListDataSetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataExchangeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDataSetsResponse> {
        public Builder dataSets(Collection<DataSetEntry> var1);

        public Builder dataSets(DataSetEntry ... var1);

        public Builder dataSets(Consumer<DataSetEntry.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

