/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Origin {
    OWNED("OWNED"),
    ENTITLED("ENTITLED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Origin(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Origin fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Origin.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Origin> knownValues() {
        return Stream.of(Origin.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

