/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databrew.model.DataBrewResponse;
import software.amazon.awssdk.services.databrew.model.RecipeErrorListCopier;
import software.amazon.awssdk.services.databrew.model.RecipeVersionErrorDetail;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteRecipeVersionResponse
extends DataBrewResponse
implements ToCopyableBuilder<Builder, BatchDeleteRecipeVersionResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(BatchDeleteRecipeVersionResponse.getter(BatchDeleteRecipeVersionResponse::name)).setter(BatchDeleteRecipeVersionResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<RecipeVersionErrorDetail>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(BatchDeleteRecipeVersionResponse.getter(BatchDeleteRecipeVersionResponse::errors)).setter(BatchDeleteRecipeVersionResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecipeVersionErrorDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchDeleteRecipeVersionResponse.memberNameToFieldInitializer();
    private final String name;
    private final List<RecipeVersionErrorDetail> errors;

    private BatchDeleteRecipeVersionResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.errors = builder.errors;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<RecipeVersionErrorDetail> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteRecipeVersionResponse)) {
            return false;
        }
        BatchDeleteRecipeVersionResponse other = (BatchDeleteRecipeVersionResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDeleteRecipeVersionResponse").add("Name", (Object)this.name()).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteRecipeVersionResponse, T> g) {
        return obj -> g.apply((BatchDeleteRecipeVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataBrewResponse.BuilderImpl
    implements Builder {
        private String name;
        private List<RecipeVersionErrorDetail> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteRecipeVersionResponse model) {
            super(model);
            this.name(model.name);
            this.errors(model.errors);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<RecipeVersionErrorDetail.Builder> getErrors() {
            List<RecipeVersionErrorDetail.Builder> result = RecipeErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<RecipeVersionErrorDetail.BuilderImpl> errors) {
            this.errors = RecipeErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<RecipeVersionErrorDetail> errors) {
            this.errors = RecipeErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(RecipeVersionErrorDetail ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<RecipeVersionErrorDetail.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (RecipeVersionErrorDetail)((RecipeVersionErrorDetail.Builder)RecipeVersionErrorDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchDeleteRecipeVersionResponse build() {
            return new BatchDeleteRecipeVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataBrewResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteRecipeVersionResponse> {
        public Builder name(String var1);

        public Builder errors(Collection<RecipeVersionErrorDetail> var1);

        public Builder errors(RecipeVersionErrorDetail ... var1);

        public Builder errors(Consumer<RecipeVersionErrorDetail.Builder> ... var1);
    }
}

