/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databrew.DataBrewAsyncClient;
import software.amazon.awssdk.services.databrew.internal.UserAgentUtils;
import software.amazon.awssdk.services.databrew.model.ListRulesetsRequest;
import software.amazon.awssdk.services.databrew.model.ListRulesetsResponse;
import software.amazon.awssdk.services.databrew.model.RulesetItem;

public class ListRulesetsPublisher
implements SdkPublisher<ListRulesetsResponse> {
    private final DataBrewAsyncClient client;
    private final ListRulesetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRulesetsPublisher(DataBrewAsyncClient client, ListRulesetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRulesetsPublisher(DataBrewAsyncClient client, ListRulesetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRulesetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRulesetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RulesetItem> rulesets() {
        Function<ListRulesetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.rulesets() != null) {
                return response.rulesets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRulesetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRulesetsResponseFetcher
    implements AsyncPageFetcher<ListRulesetsResponse> {
        private ListRulesetsResponseFetcher() {
        }

        public boolean hasNextPage(ListRulesetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRulesetsResponse> nextPage(ListRulesetsResponse previousPage) {
            if (previousPage == null) {
                return ListRulesetsPublisher.this.client.listRulesets(ListRulesetsPublisher.this.firstRequest);
            }
            return ListRulesetsPublisher.this.client.listRulesets((ListRulesetsRequest)((Object)ListRulesetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

