/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.databrew.DataBrewClient;
import software.amazon.awssdk.services.databrew.DataBrewClientBuilder;
import software.amazon.awssdk.services.databrew.DataBrewServiceClientConfiguration;
import software.amazon.awssdk.services.databrew.DefaultDataBrewBaseClientBuilder;
import software.amazon.awssdk.services.databrew.DefaultDataBrewClient;
import software.amazon.awssdk.services.databrew.endpoints.DataBrewEndpointProvider;

@SdkInternalApi
final class DefaultDataBrewClientBuilder
extends DefaultDataBrewBaseClientBuilder<DataBrewClientBuilder, DataBrewClient>
implements DataBrewClientBuilder {
    DefaultDataBrewClientBuilder() {
    }

    @Override
    public DefaultDataBrewClientBuilder endpointProvider(DataBrewEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DataBrewClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultDataBrewClientBuilder.validateClientOptions(clientConfiguration);
        DataBrewServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultDataBrewClient client = new DefaultDataBrewClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private DataBrewServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return DataBrewServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

