/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databrew.DataBrewAsyncClient;
import software.amazon.awssdk.services.databrew.model.ListRecipesRequest;
import software.amazon.awssdk.services.databrew.model.ListRecipesResponse;
import software.amazon.awssdk.services.databrew.model.Recipe;

public class ListRecipesPublisher
implements SdkPublisher<ListRecipesResponse> {
    private final DataBrewAsyncClient client;
    private final ListRecipesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRecipesPublisher(DataBrewAsyncClient client, ListRecipesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRecipesPublisher(DataBrewAsyncClient client, ListRecipesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRecipesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRecipesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Recipe> recipes() {
        Function<ListRecipesResponse, Iterator> getIterator = response -> {
            if (response != null && response.recipes() != null) {
                return response.recipes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRecipesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRecipesResponseFetcher
    implements AsyncPageFetcher<ListRecipesResponse> {
        private ListRecipesResponseFetcher() {
        }

        public boolean hasNextPage(ListRecipesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRecipesResponse> nextPage(ListRecipesResponse previousPage) {
            if (previousPage == null) {
                return ListRecipesPublisher.this.client.listRecipes(ListRecipesPublisher.this.firstRequest);
            }
            return ListRecipesPublisher.this.client.listRecipes((ListRecipesRequest)((Object)ListRecipesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

