/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.MigrationTypeValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyReplicationTaskRequest
extends DatabaseMigrationRequest
implements ToCopyableBuilder<Builder, ModifyReplicationTaskRequest> {
    private static final SdkField<String> REPLICATION_TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyReplicationTaskRequest.getter(ModifyReplicationTaskRequest::replicationTaskArn)).setter(ModifyReplicationTaskRequest.setter(Builder::replicationTaskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskArn").build()}).build();
    private static final SdkField<String> REPLICATION_TASK_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyReplicationTaskRequest.getter(ModifyReplicationTaskRequest::replicationTaskIdentifier)).setter(ModifyReplicationTaskRequest.setter(Builder::replicationTaskIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskIdentifier").build()}).build();
    private static final SdkField<String> MIGRATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyReplicationTaskRequest.getter(ModifyReplicationTaskRequest::migrationTypeAsString)).setter(ModifyReplicationTaskRequest.setter(Builder::migrationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationType").build()}).build();
    private static final SdkField<String> TABLE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyReplicationTaskRequest.getter(ModifyReplicationTaskRequest::tableMappings)).setter(ModifyReplicationTaskRequest.setter(Builder::tableMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableMappings").build()}).build();
    private static final SdkField<String> REPLICATION_TASK_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyReplicationTaskRequest.getter(ModifyReplicationTaskRequest::replicationTaskSettings)).setter(ModifyReplicationTaskRequest.setter(Builder::replicationTaskSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskSettings").build()}).build();
    private static final SdkField<Instant> CDC_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ModifyReplicationTaskRequest.getter(ModifyReplicationTaskRequest::cdcStartTime)).setter(ModifyReplicationTaskRequest.setter(Builder::cdcStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcStartTime").build()}).build();
    private static final SdkField<String> CDC_START_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyReplicationTaskRequest.getter(ModifyReplicationTaskRequest::cdcStartPosition)).setter(ModifyReplicationTaskRequest.setter(Builder::cdcStartPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcStartPosition").build()}).build();
    private static final SdkField<String> CDC_STOP_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyReplicationTaskRequest.getter(ModifyReplicationTaskRequest::cdcStopPosition)).setter(ModifyReplicationTaskRequest.setter(Builder::cdcStopPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcStopPosition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_TASK_ARN_FIELD, REPLICATION_TASK_IDENTIFIER_FIELD, MIGRATION_TYPE_FIELD, TABLE_MAPPINGS_FIELD, REPLICATION_TASK_SETTINGS_FIELD, CDC_START_TIME_FIELD, CDC_START_POSITION_FIELD, CDC_STOP_POSITION_FIELD));
    private final String replicationTaskArn;
    private final String replicationTaskIdentifier;
    private final String migrationType;
    private final String tableMappings;
    private final String replicationTaskSettings;
    private final Instant cdcStartTime;
    private final String cdcStartPosition;
    private final String cdcStopPosition;

    private ModifyReplicationTaskRequest(BuilderImpl builder) {
        super(builder);
        this.replicationTaskArn = builder.replicationTaskArn;
        this.replicationTaskIdentifier = builder.replicationTaskIdentifier;
        this.migrationType = builder.migrationType;
        this.tableMappings = builder.tableMappings;
        this.replicationTaskSettings = builder.replicationTaskSettings;
        this.cdcStartTime = builder.cdcStartTime;
        this.cdcStartPosition = builder.cdcStartPosition;
        this.cdcStopPosition = builder.cdcStopPosition;
    }

    public String replicationTaskArn() {
        return this.replicationTaskArn;
    }

    public String replicationTaskIdentifier() {
        return this.replicationTaskIdentifier;
    }

    public MigrationTypeValue migrationType() {
        return MigrationTypeValue.fromValue(this.migrationType);
    }

    public String migrationTypeAsString() {
        return this.migrationType;
    }

    public String tableMappings() {
        return this.tableMappings;
    }

    public String replicationTaskSettings() {
        return this.replicationTaskSettings;
    }

    public Instant cdcStartTime() {
        return this.cdcStartTime;
    }

    public String cdcStartPosition() {
        return this.cdcStartPosition;
    }

    public String cdcStopPosition() {
        return this.cdcStopPosition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationTaskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationTaskIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableMappings());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationTaskSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.cdcStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.cdcStartPosition());
        hashCode = 31 * hashCode + Objects.hashCode(this.cdcStopPosition());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyReplicationTaskRequest)) {
            return false;
        }
        ModifyReplicationTaskRequest other = (ModifyReplicationTaskRequest)((Object)obj);
        return Objects.equals(this.replicationTaskArn(), other.replicationTaskArn()) && Objects.equals(this.replicationTaskIdentifier(), other.replicationTaskIdentifier()) && Objects.equals(this.migrationTypeAsString(), other.migrationTypeAsString()) && Objects.equals(this.tableMappings(), other.tableMappings()) && Objects.equals(this.replicationTaskSettings(), other.replicationTaskSettings()) && Objects.equals(this.cdcStartTime(), other.cdcStartTime()) && Objects.equals(this.cdcStartPosition(), other.cdcStartPosition()) && Objects.equals(this.cdcStopPosition(), other.cdcStopPosition());
    }

    public String toString() {
        return ToString.builder((String)"ModifyReplicationTaskRequest").add("ReplicationTaskArn", (Object)this.replicationTaskArn()).add("ReplicationTaskIdentifier", (Object)this.replicationTaskIdentifier()).add("MigrationType", (Object)this.migrationTypeAsString()).add("TableMappings", (Object)this.tableMappings()).add("ReplicationTaskSettings", (Object)this.replicationTaskSettings()).add("CdcStartTime", (Object)this.cdcStartTime()).add("CdcStartPosition", (Object)this.cdcStartPosition()).add("CdcStopPosition", (Object)this.cdcStopPosition()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationTaskArn": {
                return Optional.ofNullable(clazz.cast(this.replicationTaskArn()));
            }
            case "ReplicationTaskIdentifier": {
                return Optional.ofNullable(clazz.cast(this.replicationTaskIdentifier()));
            }
            case "MigrationType": {
                return Optional.ofNullable(clazz.cast(this.migrationTypeAsString()));
            }
            case "TableMappings": {
                return Optional.ofNullable(clazz.cast(this.tableMappings()));
            }
            case "ReplicationTaskSettings": {
                return Optional.ofNullable(clazz.cast(this.replicationTaskSettings()));
            }
            case "CdcStartTime": {
                return Optional.ofNullable(clazz.cast(this.cdcStartTime()));
            }
            case "CdcStartPosition": {
                return Optional.ofNullable(clazz.cast(this.cdcStartPosition()));
            }
            case "CdcStopPosition": {
                return Optional.ofNullable(clazz.cast(this.cdcStopPosition()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyReplicationTaskRequest, T> g) {
        return obj -> g.apply((ModifyReplicationTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationRequest.BuilderImpl
    implements Builder {
        private String replicationTaskArn;
        private String replicationTaskIdentifier;
        private String migrationType;
        private String tableMappings;
        private String replicationTaskSettings;
        private Instant cdcStartTime;
        private String cdcStartPosition;
        private String cdcStopPosition;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyReplicationTaskRequest model) {
            super(model);
            this.replicationTaskArn(model.replicationTaskArn);
            this.replicationTaskIdentifier(model.replicationTaskIdentifier);
            this.migrationType(model.migrationType);
            this.tableMappings(model.tableMappings);
            this.replicationTaskSettings(model.replicationTaskSettings);
            this.cdcStartTime(model.cdcStartTime);
            this.cdcStartPosition(model.cdcStartPosition);
            this.cdcStopPosition(model.cdcStopPosition);
        }

        public final String getReplicationTaskArn() {
            return this.replicationTaskArn;
        }

        @Override
        public final Builder replicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
            return this;
        }

        public final void setReplicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
        }

        public final String getReplicationTaskIdentifier() {
            return this.replicationTaskIdentifier;
        }

        @Override
        public final Builder replicationTaskIdentifier(String replicationTaskIdentifier) {
            this.replicationTaskIdentifier = replicationTaskIdentifier;
            return this;
        }

        public final void setReplicationTaskIdentifier(String replicationTaskIdentifier) {
            this.replicationTaskIdentifier = replicationTaskIdentifier;
        }

        public final String getMigrationTypeAsString() {
            return this.migrationType;
        }

        @Override
        public final Builder migrationType(String migrationType) {
            this.migrationType = migrationType;
            return this;
        }

        @Override
        public final Builder migrationType(MigrationTypeValue migrationType) {
            this.migrationType(migrationType.toString());
            return this;
        }

        public final void setMigrationType(String migrationType) {
            this.migrationType = migrationType;
        }

        public final String getTableMappings() {
            return this.tableMappings;
        }

        @Override
        public final Builder tableMappings(String tableMappings) {
            this.tableMappings = tableMappings;
            return this;
        }

        public final void setTableMappings(String tableMappings) {
            this.tableMappings = tableMappings;
        }

        public final String getReplicationTaskSettings() {
            return this.replicationTaskSettings;
        }

        @Override
        public final Builder replicationTaskSettings(String replicationTaskSettings) {
            this.replicationTaskSettings = replicationTaskSettings;
            return this;
        }

        public final void setReplicationTaskSettings(String replicationTaskSettings) {
            this.replicationTaskSettings = replicationTaskSettings;
        }

        public final Instant getCdcStartTime() {
            return this.cdcStartTime;
        }

        @Override
        public final Builder cdcStartTime(Instant cdcStartTime) {
            this.cdcStartTime = cdcStartTime;
            return this;
        }

        public final void setCdcStartTime(Instant cdcStartTime) {
            this.cdcStartTime = cdcStartTime;
        }

        public final String getCdcStartPosition() {
            return this.cdcStartPosition;
        }

        @Override
        public final Builder cdcStartPosition(String cdcStartPosition) {
            this.cdcStartPosition = cdcStartPosition;
            return this;
        }

        public final void setCdcStartPosition(String cdcStartPosition) {
            this.cdcStartPosition = cdcStartPosition;
        }

        public final String getCdcStopPosition() {
            return this.cdcStopPosition;
        }

        @Override
        public final Builder cdcStopPosition(String cdcStopPosition) {
            this.cdcStopPosition = cdcStopPosition;
            return this;
        }

        public final void setCdcStopPosition(String cdcStopPosition) {
            this.cdcStopPosition = cdcStopPosition;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyReplicationTaskRequest build() {
            return new ModifyReplicationTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DatabaseMigrationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyReplicationTaskRequest> {
        public Builder replicationTaskArn(String var1);

        public Builder replicationTaskIdentifier(String var1);

        public Builder migrationType(String var1);

        public Builder migrationType(MigrationTypeValue var1);

        public Builder tableMappings(String var1);

        public Builder replicationTaskSettings(String var1);

        public Builder cdcStartTime(Instant var1);

        public Builder cdcStartPosition(String var1);

        public Builder cdcStopPosition(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

