/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationClient;
import software.amazon.awssdk.services.databasemigration.model.DescribeSchemasRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeSchemasResponse;

public class DescribeSchemasIterable
implements SdkIterable<DescribeSchemasResponse> {
    private final DatabaseMigrationClient client;
    private final DescribeSchemasRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeSchemasIterable(DatabaseMigrationClient client, DescribeSchemasRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeSchemasResponseFetcher();
    }

    public Iterator<DescribeSchemasResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final DescribeSchemasIterable resume(DescribeSchemasResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeSchemasIterable(this.client, (DescribeSchemasRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeSchemasIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeSchemasResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeSchemasResponseFetcher
    implements SyncPageFetcher<DescribeSchemasResponse> {
        private DescribeSchemasResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSchemasResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeSchemasResponse nextPage(DescribeSchemasResponse previousPage) {
            if (previousPage == null) {
                return DescribeSchemasIterable.this.client.describeSchemas(DescribeSchemasIterable.this.firstRequest);
            }
            return DescribeSchemasIterable.this.client.describeSchemas((DescribeSchemasRequest)((Object)DescribeSchemasIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

