/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationClient;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse;

public class DescribeReplicationInstanceTaskLogsIterable
implements SdkIterable<DescribeReplicationInstanceTaskLogsResponse> {
    private final DatabaseMigrationClient client;
    private final DescribeReplicationInstanceTaskLogsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeReplicationInstanceTaskLogsIterable(DatabaseMigrationClient client, DescribeReplicationInstanceTaskLogsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeReplicationInstanceTaskLogsResponseFetcher();
    }

    public Iterator<DescribeReplicationInstanceTaskLogsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final DescribeReplicationInstanceTaskLogsIterable resume(DescribeReplicationInstanceTaskLogsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeReplicationInstanceTaskLogsIterable(this.client, (DescribeReplicationInstanceTaskLogsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeReplicationInstanceTaskLogsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeReplicationInstanceTaskLogsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeReplicationInstanceTaskLogsResponseFetcher
    implements SyncPageFetcher<DescribeReplicationInstanceTaskLogsResponse> {
        private DescribeReplicationInstanceTaskLogsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReplicationInstanceTaskLogsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeReplicationInstanceTaskLogsResponse nextPage(DescribeReplicationInstanceTaskLogsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReplicationInstanceTaskLogsIterable.this.client.describeReplicationInstanceTaskLogs(DescribeReplicationInstanceTaskLogsIterable.this.firstRequest);
            }
            return DescribeReplicationInstanceTaskLogsIterable.this.client.describeReplicationInstanceTaskLogs((DescribeReplicationInstanceTaskLogsRequest)((Object)DescribeReplicationInstanceTaskLogsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

