/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ElasticsearchSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ElasticsearchSettings> {
    private static final SdkField<String> SERVICE_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ElasticsearchSettings.getter(ElasticsearchSettings::serviceAccessRoleArn)).setter(ElasticsearchSettings.setter(Builder::serviceAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccessRoleArn").build()}).build();
    private static final SdkField<String> ENDPOINT_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ElasticsearchSettings.getter(ElasticsearchSettings::endpointUri)).setter(ElasticsearchSettings.setter(Builder::endpointUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointUri").build()}).build();
    private static final SdkField<Integer> FULL_LOAD_ERROR_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ElasticsearchSettings.getter(ElasticsearchSettings::fullLoadErrorPercentage)).setter(ElasticsearchSettings.setter(Builder::fullLoadErrorPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullLoadErrorPercentage").build()}).build();
    private static final SdkField<Integer> ERROR_RETRY_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ElasticsearchSettings.getter(ElasticsearchSettings::errorRetryDuration)).setter(ElasticsearchSettings.setter(Builder::errorRetryDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorRetryDuration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ACCESS_ROLE_ARN_FIELD, ENDPOINT_URI_FIELD, FULL_LOAD_ERROR_PERCENTAGE_FIELD, ERROR_RETRY_DURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String serviceAccessRoleArn;
    private final String endpointUri;
    private final Integer fullLoadErrorPercentage;
    private final Integer errorRetryDuration;

    private ElasticsearchSettings(BuilderImpl builder) {
        this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
        this.endpointUri = builder.endpointUri;
        this.fullLoadErrorPercentage = builder.fullLoadErrorPercentage;
        this.errorRetryDuration = builder.errorRetryDuration;
    }

    public String serviceAccessRoleArn() {
        return this.serviceAccessRoleArn;
    }

    public String endpointUri() {
        return this.endpointUri;
    }

    public Integer fullLoadErrorPercentage() {
        return this.fullLoadErrorPercentage;
    }

    public Integer errorRetryDuration() {
        return this.errorRetryDuration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.fullLoadErrorPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorRetryDuration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticsearchSettings)) {
            return false;
        }
        ElasticsearchSettings other = (ElasticsearchSettings)obj;
        return Objects.equals(this.serviceAccessRoleArn(), other.serviceAccessRoleArn()) && Objects.equals(this.endpointUri(), other.endpointUri()) && Objects.equals(this.fullLoadErrorPercentage(), other.fullLoadErrorPercentage()) && Objects.equals(this.errorRetryDuration(), other.errorRetryDuration());
    }

    public String toString() {
        return ToString.builder((String)"ElasticsearchSettings").add("ServiceAccessRoleArn", (Object)this.serviceAccessRoleArn()).add("EndpointUri", (Object)this.endpointUri()).add("FullLoadErrorPercentage", (Object)this.fullLoadErrorPercentage()).add("ErrorRetryDuration", (Object)this.errorRetryDuration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceAccessRoleArn()));
            }
            case "EndpointUri": {
                return Optional.ofNullable(clazz.cast(this.endpointUri()));
            }
            case "FullLoadErrorPercentage": {
                return Optional.ofNullable(clazz.cast(this.fullLoadErrorPercentage()));
            }
            case "ErrorRetryDuration": {
                return Optional.ofNullable(clazz.cast(this.errorRetryDuration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ElasticsearchSettings, T> g) {
        return obj -> g.apply((ElasticsearchSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceAccessRoleArn;
        private String endpointUri;
        private Integer fullLoadErrorPercentage;
        private Integer errorRetryDuration;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticsearchSettings model) {
            this.serviceAccessRoleArn(model.serviceAccessRoleArn);
            this.endpointUri(model.endpointUri);
            this.fullLoadErrorPercentage(model.fullLoadErrorPercentage);
            this.errorRetryDuration(model.errorRetryDuration);
        }

        public final String getServiceAccessRoleArn() {
            return this.serviceAccessRoleArn;
        }

        @Override
        public final Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        public final void setServiceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
        }

        public final String getEndpointUri() {
            return this.endpointUri;
        }

        @Override
        public final Builder endpointUri(String endpointUri) {
            this.endpointUri = endpointUri;
            return this;
        }

        public final void setEndpointUri(String endpointUri) {
            this.endpointUri = endpointUri;
        }

        public final Integer getFullLoadErrorPercentage() {
            return this.fullLoadErrorPercentage;
        }

        @Override
        public final Builder fullLoadErrorPercentage(Integer fullLoadErrorPercentage) {
            this.fullLoadErrorPercentage = fullLoadErrorPercentage;
            return this;
        }

        public final void setFullLoadErrorPercentage(Integer fullLoadErrorPercentage) {
            this.fullLoadErrorPercentage = fullLoadErrorPercentage;
        }

        public final Integer getErrorRetryDuration() {
            return this.errorRetryDuration;
        }

        @Override
        public final Builder errorRetryDuration(Integer errorRetryDuration) {
            this.errorRetryDuration = errorRetryDuration;
            return this;
        }

        public final void setErrorRetryDuration(Integer errorRetryDuration) {
            this.errorRetryDuration = errorRetryDuration;
        }

        public ElasticsearchSettings build() {
            return new ElasticsearchSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ElasticsearchSettings> {
        public Builder serviceAccessRoleArn(String var1);

        public Builder endpointUri(String var1);

        public Builder fullLoadErrorPercentage(Integer var1);

        public Builder errorRetryDuration(Integer var1);
    }
}

