/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InventoryData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InventoryData> {
    private static final SdkField<Integer> NUMBER_OF_DATABASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfDatabases").getter(InventoryData.getter(InventoryData::numberOfDatabases)).setter(InventoryData.setter(Builder::numberOfDatabases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfDatabases").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_SCHEMAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfSchemas").getter(InventoryData.getter(InventoryData::numberOfSchemas)).setter(InventoryData.setter(Builder::numberOfSchemas)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfSchemas").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_OF_DATABASES_FIELD, NUMBER_OF_SCHEMAS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InventoryData.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer numberOfDatabases;
    private final Integer numberOfSchemas;

    private InventoryData(BuilderImpl builder) {
        this.numberOfDatabases = builder.numberOfDatabases;
        this.numberOfSchemas = builder.numberOfSchemas;
    }

    public final Integer numberOfDatabases() {
        return this.numberOfDatabases;
    }

    public final Integer numberOfSchemas() {
        return this.numberOfSchemas;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfDatabases());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfSchemas());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryData)) {
            return false;
        }
        InventoryData other = (InventoryData)obj;
        return Objects.equals(this.numberOfDatabases(), other.numberOfDatabases()) && Objects.equals(this.numberOfSchemas(), other.numberOfSchemas());
    }

    public final String toString() {
        return ToString.builder((String)"InventoryData").add("NumberOfDatabases", (Object)this.numberOfDatabases()).add("NumberOfSchemas", (Object)this.numberOfSchemas()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NumberOfDatabases": {
                return Optional.ofNullable(clazz.cast(this.numberOfDatabases()));
            }
            case "NumberOfSchemas": {
                return Optional.ofNullable(clazz.cast(this.numberOfSchemas()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Integer>> map = new HashMap<String, SdkField<Integer>>();
        map.put("NumberOfDatabases", NUMBER_OF_DATABASES_FIELD);
        map.put("NumberOfSchemas", NUMBER_OF_SCHEMAS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InventoryData, T> g) {
        return obj -> g.apply((InventoryData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer numberOfDatabases;
        private Integer numberOfSchemas;

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryData model) {
            this.numberOfDatabases(model.numberOfDatabases);
            this.numberOfSchemas(model.numberOfSchemas);
        }

        public final Integer getNumberOfDatabases() {
            return this.numberOfDatabases;
        }

        public final void setNumberOfDatabases(Integer numberOfDatabases) {
            this.numberOfDatabases = numberOfDatabases;
        }

        @Override
        public final Builder numberOfDatabases(Integer numberOfDatabases) {
            this.numberOfDatabases = numberOfDatabases;
            return this;
        }

        public final Integer getNumberOfSchemas() {
            return this.numberOfSchemas;
        }

        public final void setNumberOfSchemas(Integer numberOfSchemas) {
            this.numberOfSchemas = numberOfSchemas;
        }

        @Override
        public final Builder numberOfSchemas(Integer numberOfSchemas) {
            this.numberOfSchemas = numberOfSchemas;
            return this;
        }

        public InventoryData build() {
            return new InventoryData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InventoryData> {
        public Builder numberOfDatabases(Integer var1);

        public Builder numberOfSchemas(Integer var1);
    }
}

