/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RedshiftDataProviderSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RedshiftDataProviderSettings> {
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerName").getter(RedshiftDataProviderSettings.getter(RedshiftDataProviderSettings::serverName)).setter(RedshiftDataProviderSettings.setter(Builder::serverName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(RedshiftDataProviderSettings.getter(RedshiftDataProviderSettings::port)).setter(RedshiftDataProviderSettings.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(RedshiftDataProviderSettings.getter(RedshiftDataProviderSettings::databaseName)).setter(RedshiftDataProviderSettings.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_NAME_FIELD, PORT_FIELD, DATABASE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RedshiftDataProviderSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String serverName;
    private final Integer port;
    private final String databaseName;

    private RedshiftDataProviderSettings(BuilderImpl builder) {
        this.serverName = builder.serverName;
        this.port = builder.port;
        this.databaseName = builder.databaseName;
    }

    public final String serverName() {
        return this.serverName;
    }

    public final Integer port() {
        return this.port;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serverName());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftDataProviderSettings)) {
            return false;
        }
        RedshiftDataProviderSettings other = (RedshiftDataProviderSettings)obj;
        return Objects.equals(this.serverName(), other.serverName()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.databaseName(), other.databaseName());
    }

    public final String toString() {
        return ToString.builder((String)"RedshiftDataProviderSettings").add("ServerName", (Object)this.serverName()).add("Port", (Object)this.port()).add("DatabaseName", (Object)this.databaseName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServerName": {
                return Optional.ofNullable(clazz.cast(this.serverName()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ServerName", SERVER_NAME_FIELD);
        map.put("Port", PORT_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RedshiftDataProviderSettings, T> g) {
        return obj -> g.apply((RedshiftDataProviderSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serverName;
        private Integer port;
        private String databaseName;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftDataProviderSettings model) {
            this.serverName(model.serverName);
            this.port(model.port);
            this.databaseName(model.databaseName);
        }

        public final String getServerName() {
            return this.serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public RedshiftDataProviderSettings build() {
            return new RedshiftDataProviderSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RedshiftDataProviderSettings> {
        public Builder serverName(String var1);

        public Builder port(Integer var1);

        public Builder databaseName(String var1);
    }
}

