/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.DmsSslModeValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MySqlDataProviderSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MySqlDataProviderSettings> {
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerName").getter(MySqlDataProviderSettings.getter(MySqlDataProviderSettings::serverName)).setter(MySqlDataProviderSettings.setter(Builder::serverName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(MySqlDataProviderSettings.getter(MySqlDataProviderSettings::port)).setter(MySqlDataProviderSettings.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> SSL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SslMode").getter(MySqlDataProviderSettings.getter(MySqlDataProviderSettings::sslModeAsString)).setter(MySqlDataProviderSettings.setter(Builder::sslMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslMode").build()}).build();
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateArn").getter(MySqlDataProviderSettings.getter(MySqlDataProviderSettings::certificateArn)).setter(MySqlDataProviderSettings.setter(Builder::certificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_NAME_FIELD, PORT_FIELD, SSL_MODE_FIELD, CERTIFICATE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MySqlDataProviderSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String serverName;
    private final Integer port;
    private final String sslMode;
    private final String certificateArn;

    private MySqlDataProviderSettings(BuilderImpl builder) {
        this.serverName = builder.serverName;
        this.port = builder.port;
        this.sslMode = builder.sslMode;
        this.certificateArn = builder.certificateArn;
    }

    public final String serverName() {
        return this.serverName;
    }

    public final Integer port() {
        return this.port;
    }

    public final DmsSslModeValue sslMode() {
        return DmsSslModeValue.fromValue(this.sslMode);
    }

    public final String sslModeAsString() {
        return this.sslMode;
    }

    public final String certificateArn() {
        return this.certificateArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serverName());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.sslModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MySqlDataProviderSettings)) {
            return false;
        }
        MySqlDataProviderSettings other = (MySqlDataProviderSettings)obj;
        return Objects.equals(this.serverName(), other.serverName()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.sslModeAsString(), other.sslModeAsString()) && Objects.equals(this.certificateArn(), other.certificateArn());
    }

    public final String toString() {
        return ToString.builder((String)"MySqlDataProviderSettings").add("ServerName", (Object)this.serverName()).add("Port", (Object)this.port()).add("SslMode", (Object)this.sslModeAsString()).add("CertificateArn", (Object)this.certificateArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServerName": {
                return Optional.ofNullable(clazz.cast(this.serverName()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "SslMode": {
                return Optional.ofNullable(clazz.cast(this.sslModeAsString()));
            }
            case "CertificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ServerName", SERVER_NAME_FIELD);
        map.put("Port", PORT_FIELD);
        map.put("SslMode", SSL_MODE_FIELD);
        map.put("CertificateArn", CERTIFICATE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MySqlDataProviderSettings, T> g) {
        return obj -> g.apply((MySqlDataProviderSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serverName;
        private Integer port;
        private String sslMode;
        private String certificateArn;

        private BuilderImpl() {
        }

        private BuilderImpl(MySqlDataProviderSettings model) {
            this.serverName(model.serverName);
            this.port(model.port);
            this.sslMode(model.sslMode);
            this.certificateArn(model.certificateArn);
        }

        public final String getServerName() {
            return this.serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getSslMode() {
            return this.sslMode;
        }

        public final void setSslMode(String sslMode) {
            this.sslMode = sslMode;
        }

        @Override
        public final Builder sslMode(String sslMode) {
            this.sslMode = sslMode;
            return this;
        }

        @Override
        public final Builder sslMode(DmsSslModeValue sslMode) {
            this.sslMode(sslMode == null ? null : sslMode.toString());
            return this;
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public MySqlDataProviderSettings build() {
            return new MySqlDataProviderSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MySqlDataProviderSettings> {
        public Builder serverName(String var1);

        public Builder port(Integer var1);

        public Builder sslMode(String var1);

        public Builder sslMode(DmsSslModeValue var1);

        public Builder certificateArn(String var1);
    }
}

