/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.FleetAdvisorSchemaListCopier;
import software.amazon.awssdk.services.databasemigration.model.SchemaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFleetAdvisorSchemasResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DescribeFleetAdvisorSchemasResponse> {
    private static final SdkField<List<SchemaResponse>> FLEET_ADVISOR_SCHEMAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FleetAdvisorSchemas").getter(DescribeFleetAdvisorSchemasResponse.getter(DescribeFleetAdvisorSchemasResponse::fleetAdvisorSchemas)).setter(DescribeFleetAdvisorSchemasResponse.setter(Builder::fleetAdvisorSchemas)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetAdvisorSchemas").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SchemaResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeFleetAdvisorSchemasResponse.getter(DescribeFleetAdvisorSchemasResponse::nextToken)).setter(DescribeFleetAdvisorSchemasResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ADVISOR_SCHEMAS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeFleetAdvisorSchemasResponse.memberNameToFieldInitializer();
    private final List<SchemaResponse> fleetAdvisorSchemas;
    private final String nextToken;

    private DescribeFleetAdvisorSchemasResponse(BuilderImpl builder) {
        super(builder);
        this.fleetAdvisorSchemas = builder.fleetAdvisorSchemas;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasFleetAdvisorSchemas() {
        return this.fleetAdvisorSchemas != null && !(this.fleetAdvisorSchemas instanceof SdkAutoConstructList);
    }

    public final List<SchemaResponse> fleetAdvisorSchemas() {
        return this.fleetAdvisorSchemas;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFleetAdvisorSchemas() ? this.fleetAdvisorSchemas() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetAdvisorSchemasResponse)) {
            return false;
        }
        DescribeFleetAdvisorSchemasResponse other = (DescribeFleetAdvisorSchemasResponse)((Object)obj);
        return this.hasFleetAdvisorSchemas() == other.hasFleetAdvisorSchemas() && Objects.equals(this.fleetAdvisorSchemas(), other.fleetAdvisorSchemas()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFleetAdvisorSchemasResponse").add("FleetAdvisorSchemas", this.hasFleetAdvisorSchemas() ? this.fleetAdvisorSchemas() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetAdvisorSchemas": {
                return Optional.ofNullable(clazz.cast(this.fleetAdvisorSchemas()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FleetAdvisorSchemas", FLEET_ADVISOR_SCHEMAS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeFleetAdvisorSchemasResponse, T> g) {
        return obj -> g.apply((DescribeFleetAdvisorSchemasResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private List<SchemaResponse> fleetAdvisorSchemas = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetAdvisorSchemasResponse model) {
            super(model);
            this.fleetAdvisorSchemas(model.fleetAdvisorSchemas);
            this.nextToken(model.nextToken);
        }

        public final List<SchemaResponse.Builder> getFleetAdvisorSchemas() {
            List<SchemaResponse.Builder> result = FleetAdvisorSchemaListCopier.copyToBuilder(this.fleetAdvisorSchemas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFleetAdvisorSchemas(Collection<SchemaResponse.BuilderImpl> fleetAdvisorSchemas) {
            this.fleetAdvisorSchemas = FleetAdvisorSchemaListCopier.copyFromBuilder(fleetAdvisorSchemas);
        }

        @Override
        public final Builder fleetAdvisorSchemas(Collection<SchemaResponse> fleetAdvisorSchemas) {
            this.fleetAdvisorSchemas = FleetAdvisorSchemaListCopier.copy(fleetAdvisorSchemas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetAdvisorSchemas(SchemaResponse ... fleetAdvisorSchemas) {
            this.fleetAdvisorSchemas(Arrays.asList(fleetAdvisorSchemas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetAdvisorSchemas(Consumer<SchemaResponse.Builder> ... fleetAdvisorSchemas) {
            this.fleetAdvisorSchemas(Stream.of(fleetAdvisorSchemas).map(c -> (SchemaResponse)((SchemaResponse.Builder)SchemaResponse.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeFleetAdvisorSchemasResponse build() {
            return new DescribeFleetAdvisorSchemasResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFleetAdvisorSchemasResponse> {
        public Builder fleetAdvisorSchemas(Collection<SchemaResponse> var1);

        public Builder fleetAdvisorSchemas(SchemaResponse ... var1);

        public Builder fleetAdvisorSchemas(Consumer<SchemaResponse.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

