/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.Limitation;
import software.amazon.awssdk.services.databasemigration.model.LimitationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRecommendationLimitationsResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DescribeRecommendationLimitationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeRecommendationLimitationsResponse.getter(DescribeRecommendationLimitationsResponse::nextToken)).setter(DescribeRecommendationLimitationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<Limitation>> LIMITATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Limitations").getter(DescribeRecommendationLimitationsResponse.getter(DescribeRecommendationLimitationsResponse::limitations)).setter(DescribeRecommendationLimitationsResponse.setter(Builder::limitations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limitations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Limitation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, LIMITATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeRecommendationLimitationsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<Limitation> limitations;

    private DescribeRecommendationLimitationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.limitations = builder.limitations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasLimitations() {
        return this.limitations != null && !(this.limitations instanceof SdkAutoConstructList);
    }

    public final List<Limitation> limitations() {
        return this.limitations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLimitations() ? this.limitations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRecommendationLimitationsResponse)) {
            return false;
        }
        DescribeRecommendationLimitationsResponse other = (DescribeRecommendationLimitationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasLimitations() == other.hasLimitations() && Objects.equals(this.limitations(), other.limitations());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeRecommendationLimitationsResponse").add("NextToken", (Object)this.nextToken()).add("Limitations", this.hasLimitations() ? this.limitations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Limitations": {
                return Optional.ofNullable(clazz.cast(this.limitations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Limitations", LIMITATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRecommendationLimitationsResponse, T> g) {
        return obj -> g.apply((DescribeRecommendationLimitationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<Limitation> limitations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRecommendationLimitationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.limitations(model.limitations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Limitation.Builder> getLimitations() {
            List<Limitation.Builder> result = LimitationListCopier.copyToBuilder(this.limitations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLimitations(Collection<Limitation.BuilderImpl> limitations) {
            this.limitations = LimitationListCopier.copyFromBuilder(limitations);
        }

        @Override
        public final Builder limitations(Collection<Limitation> limitations) {
            this.limitations = LimitationListCopier.copy(limitations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder limitations(Limitation ... limitations) {
            this.limitations(Arrays.asList(limitations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder limitations(Consumer<Limitation.Builder> ... limitations) {
            this.limitations(Stream.of(limitations).map(c -> (Limitation)((Limitation.Builder)Limitation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeRecommendationLimitationsResponse build() {
            return new DescribeRecommendationLimitationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRecommendationLimitationsResponse> {
        public Builder nextToken(String var1);

        public Builder limitations(Collection<Limitation> var1);

        public Builder limitations(Limitation ... var1);

        public Builder limitations(Consumer<Limitation.Builder> ... var1);
    }
}

