/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.StringListCopier;
import software.amazon.awssdk.services.databasemigration.model.Tag;
import software.amazon.awssdk.services.databasemigration.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateInstanceProfileRequest
extends DatabaseMigrationRequest
implements ToCopyableBuilder<Builder, CreateInstanceProfileRequest> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(CreateInstanceProfileRequest.getter(CreateInstanceProfileRequest::availabilityZone)).setter(CreateInstanceProfileRequest.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyArn").getter(CreateInstanceProfileRequest.getter(CreateInstanceProfileRequest::kmsKeyArn)).setter(CreateInstanceProfileRequest.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()}).build();
    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PubliclyAccessible").getter(CreateInstanceProfileRequest.getter(CreateInstanceProfileRequest::publiclyAccessible)).setter(CreateInstanceProfileRequest.setter(Builder::publiclyAccessible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateInstanceProfileRequest.getter(CreateInstanceProfileRequest::tags)).setter(CreateInstanceProfileRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkType").getter(CreateInstanceProfileRequest.getter(CreateInstanceProfileRequest::networkType)).setter(CreateInstanceProfileRequest.setter(Builder::networkType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkType").build()}).build();
    private static final SdkField<String> INSTANCE_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceProfileName").getter(CreateInstanceProfileRequest.getter(CreateInstanceProfileRequest::instanceProfileName)).setter(CreateInstanceProfileRequest.setter(Builder::instanceProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceProfileName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateInstanceProfileRequest.getter(CreateInstanceProfileRequest::description)).setter(CreateInstanceProfileRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> SUBNET_GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetGroupIdentifier").getter(CreateInstanceProfileRequest.getter(CreateInstanceProfileRequest::subnetGroupIdentifier)).setter(CreateInstanceProfileRequest.setter(Builder::subnetGroupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetGroupIdentifier").build()}).build();
    private static final SdkField<List<String>> VPC_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcSecurityGroups").getter(CreateInstanceProfileRequest.getter(CreateInstanceProfileRequest::vpcSecurityGroups)).setter(CreateInstanceProfileRequest.setter(Builder::vpcSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD, KMS_KEY_ARN_FIELD, PUBLICLY_ACCESSIBLE_FIELD, TAGS_FIELD, NETWORK_TYPE_FIELD, INSTANCE_PROFILE_NAME_FIELD, DESCRIPTION_FIELD, SUBNET_GROUP_IDENTIFIER_FIELD, VPC_SECURITY_GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateInstanceProfileRequest.memberNameToFieldInitializer();
    private final String availabilityZone;
    private final String kmsKeyArn;
    private final Boolean publiclyAccessible;
    private final List<Tag> tags;
    private final String networkType;
    private final String instanceProfileName;
    private final String description;
    private final String subnetGroupIdentifier;
    private final List<String> vpcSecurityGroups;

    private CreateInstanceProfileRequest(BuilderImpl builder) {
        super(builder);
        this.availabilityZone = builder.availabilityZone;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.tags = builder.tags;
        this.networkType = builder.networkType;
        this.instanceProfileName = builder.instanceProfileName;
        this.description = builder.description;
        this.subnetGroupIdentifier = builder.subnetGroupIdentifier;
        this.vpcSecurityGroups = builder.vpcSecurityGroups;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String networkType() {
        return this.networkType;
    }

    public final String instanceProfileName() {
        return this.instanceProfileName;
    }

    public final String description() {
        return this.description;
    }

    public final String subnetGroupIdentifier() {
        return this.subnetGroupIdentifier;
    }

    public final boolean hasVpcSecurityGroups() {
        return this.vpcSecurityGroups != null && !(this.vpcSecurityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> vpcSecurityGroups() {
        return this.vpcSecurityGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.networkType());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSecurityGroups() ? this.vpcSecurityGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstanceProfileRequest)) {
            return false;
        }
        CreateInstanceProfileRequest other = (CreateInstanceProfileRequest)((Object)obj);
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.networkType(), other.networkType()) && Objects.equals(this.instanceProfileName(), other.instanceProfileName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.subnetGroupIdentifier(), other.subnetGroupIdentifier()) && this.hasVpcSecurityGroups() == other.hasVpcSecurityGroups() && Objects.equals(this.vpcSecurityGroups(), other.vpcSecurityGroups());
    }

    public final String toString() {
        return ToString.builder((String)"CreateInstanceProfileRequest").add("AvailabilityZone", (Object)this.availabilityZone()).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("Tags", this.hasTags() ? this.tags() : null).add("NetworkType", (Object)this.networkType()).add("InstanceProfileName", (Object)this.instanceProfileName()).add("Description", (Object)this.description()).add("SubnetGroupIdentifier", (Object)this.subnetGroupIdentifier()).add("VpcSecurityGroups", this.hasVpcSecurityGroups() ? this.vpcSecurityGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "KmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "PubliclyAccessible": {
                return Optional.ofNullable(clazz.cast(this.publiclyAccessible()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "NetworkType": {
                return Optional.ofNullable(clazz.cast(this.networkType()));
            }
            case "InstanceProfileName": {
                return Optional.ofNullable(clazz.cast(this.instanceProfileName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "SubnetGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.subnetGroupIdentifier()));
            }
            case "VpcSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("KmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("PubliclyAccessible", PUBLICLY_ACCESSIBLE_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("NetworkType", NETWORK_TYPE_FIELD);
        map.put("InstanceProfileName", INSTANCE_PROFILE_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("SubnetGroupIdentifier", SUBNET_GROUP_IDENTIFIER_FIELD);
        map.put("VpcSecurityGroups", VPC_SECURITY_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateInstanceProfileRequest, T> g) {
        return obj -> g.apply((CreateInstanceProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationRequest.BuilderImpl
    implements Builder {
        private String availabilityZone;
        private String kmsKeyArn;
        private Boolean publiclyAccessible;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String networkType;
        private String instanceProfileName;
        private String description;
        private String subnetGroupIdentifier;
        private List<String> vpcSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstanceProfileRequest model) {
            super(model);
            this.availabilityZone(model.availabilityZone);
            this.kmsKeyArn(model.kmsKeyArn);
            this.publiclyAccessible(model.publiclyAccessible);
            this.tags(model.tags);
            this.networkType(model.networkType);
            this.instanceProfileName(model.instanceProfileName);
            this.description(model.description);
            this.subnetGroupIdentifier(model.subnetGroupIdentifier);
            this.vpcSecurityGroups(model.vpcSecurityGroups);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNetworkType() {
            return this.networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        public final String getInstanceProfileName() {
            return this.instanceProfileName;
        }

        public final void setInstanceProfileName(String instanceProfileName) {
            this.instanceProfileName = instanceProfileName;
        }

        @Override
        public final Builder instanceProfileName(String instanceProfileName) {
            this.instanceProfileName = instanceProfileName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSubnetGroupIdentifier() {
            return this.subnetGroupIdentifier;
        }

        public final void setSubnetGroupIdentifier(String subnetGroupIdentifier) {
            this.subnetGroupIdentifier = subnetGroupIdentifier;
        }

        @Override
        public final Builder subnetGroupIdentifier(String subnetGroupIdentifier) {
            this.subnetGroupIdentifier = subnetGroupIdentifier;
            return this;
        }

        public final Collection<String> getVpcSecurityGroups() {
            if (this.vpcSecurityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcSecurityGroups;
        }

        public final void setVpcSecurityGroups(Collection<String> vpcSecurityGroups) {
            this.vpcSecurityGroups = StringListCopier.copy(vpcSecurityGroups);
        }

        @Override
        public final Builder vpcSecurityGroups(Collection<String> vpcSecurityGroups) {
            this.vpcSecurityGroups = StringListCopier.copy(vpcSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(String ... vpcSecurityGroups) {
            this.vpcSecurityGroups(Arrays.asList(vpcSecurityGroups));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInstanceProfileRequest build() {
            return new CreateInstanceProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DatabaseMigrationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateInstanceProfileRequest> {
        public Builder availabilityZone(String var1);

        public Builder kmsKeyArn(String var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder networkType(String var1);

        public Builder instanceProfileName(String var1);

        public Builder description(String var1);

        public Builder subnetGroupIdentifier(String var1);

        public Builder vpcSecurityGroups(Collection<String> var1);

        public Builder vpcSecurityGroups(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

