/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesResponse;

public class DescribeOrderableReplicationInstancesIterable
implements SdkIterable<DescribeOrderableReplicationInstancesResponse> {
    private final DatabaseMigrationClient client;
    private final DescribeOrderableReplicationInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeOrderableReplicationInstancesIterable(DatabaseMigrationClient client, DescribeOrderableReplicationInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeOrderableReplicationInstancesResponseFetcher();
    }

    public Iterator<DescribeOrderableReplicationInstancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeOrderableReplicationInstancesResponseFetcher
    implements SyncPageFetcher<DescribeOrderableReplicationInstancesResponse> {
        private DescribeOrderableReplicationInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOrderableReplicationInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeOrderableReplicationInstancesResponse nextPage(DescribeOrderableReplicationInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeOrderableReplicationInstancesIterable.this.client.describeOrderableReplicationInstances(DescribeOrderableReplicationInstancesIterable.this.firstRequest);
            }
            return DescribeOrderableReplicationInstancesIterable.this.client.describeOrderableReplicationInstances((DescribeOrderableReplicationInstancesRequest)((Object)DescribeOrderableReplicationInstancesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

