/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationAsyncClient;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesResponse;

public class DescribeEndpointTypesPublisher
implements SdkPublisher<DescribeEndpointTypesResponse> {
    private final DatabaseMigrationAsyncClient client;
    private final DescribeEndpointTypesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeEndpointTypesPublisher(DatabaseMigrationAsyncClient client, DescribeEndpointTypesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeEndpointTypesPublisher(DatabaseMigrationAsyncClient client, DescribeEndpointTypesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeEndpointTypesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeEndpointTypesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final DescribeEndpointTypesPublisher resume(DescribeEndpointTypesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeEndpointTypesPublisher(this.client, (DescribeEndpointTypesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeEndpointTypesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeEndpointTypesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeEndpointTypesResponseFetcher
    implements AsyncPageFetcher<DescribeEndpointTypesResponse> {
        private DescribeEndpointTypesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEndpointTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeEndpointTypesResponse> nextPage(DescribeEndpointTypesResponse previousPage) {
            if (previousPage == null) {
                return DescribeEndpointTypesPublisher.this.client.describeEndpointTypes(DescribeEndpointTypesPublisher.this.firstRequest);
            }
            return DescribeEndpointTypesPublisher.this.client.describeEndpointTypes((DescribeEndpointTypesRequest)((Object)DescribeEndpointTypesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

