/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationClient;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesResponse;

public class DescribeEndpointTypesIterable
implements SdkIterable<DescribeEndpointTypesResponse> {
    private final DatabaseMigrationClient client;
    private final DescribeEndpointTypesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeEndpointTypesIterable(DatabaseMigrationClient client, DescribeEndpointTypesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeEndpointTypesResponseFetcher();
    }

    public Iterator<DescribeEndpointTypesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final DescribeEndpointTypesIterable resume(DescribeEndpointTypesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeEndpointTypesIterable(this.client, (DescribeEndpointTypesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeEndpointTypesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeEndpointTypesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeEndpointTypesResponseFetcher
    implements SyncPageFetcher<DescribeEndpointTypesResponse> {
        private DescribeEndpointTypesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEndpointTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeEndpointTypesResponse nextPage(DescribeEndpointTypesResponse previousPage) {
            if (previousPage == null) {
                return DescribeEndpointTypesIterable.this.client.describeEndpointTypes(DescribeEndpointTypesIterable.this.firstRequest);
            }
            return DescribeEndpointTypesIterable.this.client.describeEndpointTypes((DescribeEndpointTypesRequest)((Object)DescribeEndpointTypesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

