/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.CompressionTypeValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3Settings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3Settings> {
    private static final SdkField<String> SERVICE_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3Settings.getter(S3Settings::serviceAccessRoleArn)).setter(S3Settings.setter(Builder::serviceAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccessRoleArn").build()}).build();
    private static final SdkField<String> EXTERNAL_TABLE_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3Settings.getter(S3Settings::externalTableDefinition)).setter(S3Settings.setter(Builder::externalTableDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalTableDefinition").build()}).build();
    private static final SdkField<String> CSV_ROW_DELIMITER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3Settings.getter(S3Settings::csvRowDelimiter)).setter(S3Settings.setter(Builder::csvRowDelimiter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CsvRowDelimiter").build()}).build();
    private static final SdkField<String> CSV_DELIMITER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3Settings.getter(S3Settings::csvDelimiter)).setter(S3Settings.setter(Builder::csvDelimiter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CsvDelimiter").build()}).build();
    private static final SdkField<String> BUCKET_FOLDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3Settings.getter(S3Settings::bucketFolder)).setter(S3Settings.setter(Builder::bucketFolder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketFolder").build()}).build();
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3Settings.getter(S3Settings::bucketName)).setter(S3Settings.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketName").build()}).build();
    private static final SdkField<String> COMPRESSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3Settings.getter(S3Settings::compressionTypeAsString)).setter(S3Settings.setter(Builder::compressionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompressionType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ACCESS_ROLE_ARN_FIELD, EXTERNAL_TABLE_DEFINITION_FIELD, CSV_ROW_DELIMITER_FIELD, CSV_DELIMITER_FIELD, BUCKET_FOLDER_FIELD, BUCKET_NAME_FIELD, COMPRESSION_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String serviceAccessRoleArn;
    private final String externalTableDefinition;
    private final String csvRowDelimiter;
    private final String csvDelimiter;
    private final String bucketFolder;
    private final String bucketName;
    private final String compressionType;

    private S3Settings(BuilderImpl builder) {
        this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
        this.externalTableDefinition = builder.externalTableDefinition;
        this.csvRowDelimiter = builder.csvRowDelimiter;
        this.csvDelimiter = builder.csvDelimiter;
        this.bucketFolder = builder.bucketFolder;
        this.bucketName = builder.bucketName;
        this.compressionType = builder.compressionType;
    }

    public String serviceAccessRoleArn() {
        return this.serviceAccessRoleArn;
    }

    public String externalTableDefinition() {
        return this.externalTableDefinition;
    }

    public String csvRowDelimiter() {
        return this.csvRowDelimiter;
    }

    public String csvDelimiter() {
        return this.csvDelimiter;
    }

    public String bucketFolder() {
        return this.bucketFolder;
    }

    public String bucketName() {
        return this.bucketName;
    }

    public CompressionTypeValue compressionType() {
        return CompressionTypeValue.fromValue(this.compressionType);
    }

    public String compressionTypeAsString() {
        return this.compressionType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalTableDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.csvRowDelimiter());
        hashCode = 31 * hashCode + Objects.hashCode(this.csvDelimiter());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketFolder());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.compressionTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Settings)) {
            return false;
        }
        S3Settings other = (S3Settings)obj;
        return Objects.equals(this.serviceAccessRoleArn(), other.serviceAccessRoleArn()) && Objects.equals(this.externalTableDefinition(), other.externalTableDefinition()) && Objects.equals(this.csvRowDelimiter(), other.csvRowDelimiter()) && Objects.equals(this.csvDelimiter(), other.csvDelimiter()) && Objects.equals(this.bucketFolder(), other.bucketFolder()) && Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.compressionTypeAsString(), other.compressionTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"S3Settings").add("ServiceAccessRoleArn", (Object)this.serviceAccessRoleArn()).add("ExternalTableDefinition", (Object)this.externalTableDefinition()).add("CsvRowDelimiter", (Object)this.csvRowDelimiter()).add("CsvDelimiter", (Object)this.csvDelimiter()).add("BucketFolder", (Object)this.bucketFolder()).add("BucketName", (Object)this.bucketName()).add("CompressionType", (Object)this.compressionTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceAccessRoleArn()));
            }
            case "ExternalTableDefinition": {
                return Optional.ofNullable(clazz.cast(this.externalTableDefinition()));
            }
            case "CsvRowDelimiter": {
                return Optional.ofNullable(clazz.cast(this.csvRowDelimiter()));
            }
            case "CsvDelimiter": {
                return Optional.ofNullable(clazz.cast(this.csvDelimiter()));
            }
            case "BucketFolder": {
                return Optional.ofNullable(clazz.cast(this.bucketFolder()));
            }
            case "BucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "CompressionType": {
                return Optional.ofNullable(clazz.cast(this.compressionTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3Settings, T> g) {
        return obj -> g.apply((S3Settings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceAccessRoleArn;
        private String externalTableDefinition;
        private String csvRowDelimiter;
        private String csvDelimiter;
        private String bucketFolder;
        private String bucketName;
        private String compressionType;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Settings model) {
            this.serviceAccessRoleArn(model.serviceAccessRoleArn);
            this.externalTableDefinition(model.externalTableDefinition);
            this.csvRowDelimiter(model.csvRowDelimiter);
            this.csvDelimiter(model.csvDelimiter);
            this.bucketFolder(model.bucketFolder);
            this.bucketName(model.bucketName);
            this.compressionType(model.compressionType);
        }

        public final String getServiceAccessRoleArn() {
            return this.serviceAccessRoleArn;
        }

        @Override
        public final Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        public final void setServiceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
        }

        public final String getExternalTableDefinition() {
            return this.externalTableDefinition;
        }

        @Override
        public final Builder externalTableDefinition(String externalTableDefinition) {
            this.externalTableDefinition = externalTableDefinition;
            return this;
        }

        public final void setExternalTableDefinition(String externalTableDefinition) {
            this.externalTableDefinition = externalTableDefinition;
        }

        public final String getCsvRowDelimiter() {
            return this.csvRowDelimiter;
        }

        @Override
        public final Builder csvRowDelimiter(String csvRowDelimiter) {
            this.csvRowDelimiter = csvRowDelimiter;
            return this;
        }

        public final void setCsvRowDelimiter(String csvRowDelimiter) {
            this.csvRowDelimiter = csvRowDelimiter;
        }

        public final String getCsvDelimiter() {
            return this.csvDelimiter;
        }

        @Override
        public final Builder csvDelimiter(String csvDelimiter) {
            this.csvDelimiter = csvDelimiter;
            return this;
        }

        public final void setCsvDelimiter(String csvDelimiter) {
            this.csvDelimiter = csvDelimiter;
        }

        public final String getBucketFolder() {
            return this.bucketFolder;
        }

        @Override
        public final Builder bucketFolder(String bucketFolder) {
            this.bucketFolder = bucketFolder;
            return this;
        }

        public final void setBucketFolder(String bucketFolder) {
            this.bucketFolder = bucketFolder;
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final String getCompressionTypeAsString() {
            return this.compressionType;
        }

        @Override
        public final Builder compressionType(String compressionType) {
            this.compressionType = compressionType;
            return this;
        }

        @Override
        public final Builder compressionType(CompressionTypeValue compressionType) {
            this.compressionType(compressionType.toString());
            return this;
        }

        public final void setCompressionType(String compressionType) {
            this.compressionType = compressionType;
        }

        public S3Settings build() {
            return new S3Settings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3Settings> {
        public Builder serviceAccessRoleArn(String var1);

        public Builder externalTableDefinition(String var1);

        public Builder csvRowDelimiter(String var1);

        public Builder csvDelimiter(String var1);

        public Builder bucketFolder(String var1);

        public Builder bucketName(String var1);

        public Builder compressionType(String var1);

        public Builder compressionType(CompressionTypeValue var1);
    }
}

