/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationAsyncClient;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventsResponse;

public class DescribeEventsPublisher
implements SdkPublisher<DescribeEventsResponse> {
    private final DatabaseMigrationAsyncClient client;
    private final DescribeEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeEventsPublisher(DatabaseMigrationAsyncClient client, DescribeEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeEventsPublisher(DatabaseMigrationAsyncClient client, DescribeEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final DescribeEventsPublisher resume(DescribeEventsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeEventsPublisher(this.client, (DescribeEventsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeEventsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeEventsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeEventsResponseFetcher
    implements AsyncPageFetcher<DescribeEventsResponse> {
        private DescribeEventsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeEventsResponse> nextPage(DescribeEventsResponse previousPage) {
            if (previousPage == null) {
                return DescribeEventsPublisher.this.client.describeEvents(DescribeEventsPublisher.this.firstRequest);
            }
            return DescribeEventsPublisher.this.client.describeEvents((DescribeEventsRequest)((Object)DescribeEventsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

