/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.AuthMechanismValue;
import software.amazon.awssdk.services.databasemigration.model.AuthTypeValue;
import software.amazon.awssdk.services.databasemigration.model.NestingLevelValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MongoDbSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MongoDbSettings> {
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MongoDbSettings.getter(MongoDbSettings::username)).setter(MongoDbSettings.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final SdkField<String> PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MongoDbSettings.getter(MongoDbSettings::password)).setter(MongoDbSettings.setter(Builder::password)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()}).build();
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MongoDbSettings.getter(MongoDbSettings::serverName)).setter(MongoDbSettings.setter(Builder::serverName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(MongoDbSettings.getter(MongoDbSettings::port)).setter(MongoDbSettings.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MongoDbSettings.getter(MongoDbSettings::databaseName)).setter(MongoDbSettings.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MongoDbSettings.getter(MongoDbSettings::authTypeAsString)).setter(MongoDbSettings.setter(Builder::authType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthType").build()}).build();
    private static final SdkField<String> AUTH_MECHANISM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MongoDbSettings.getter(MongoDbSettings::authMechanismAsString)).setter(MongoDbSettings.setter(Builder::authMechanism)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthMechanism").build()}).build();
    private static final SdkField<String> NESTING_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MongoDbSettings.getter(MongoDbSettings::nestingLevelAsString)).setter(MongoDbSettings.setter(Builder::nestingLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NestingLevel").build()}).build();
    private static final SdkField<String> EXTRACT_DOC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MongoDbSettings.getter(MongoDbSettings::extractDocId)).setter(MongoDbSettings.setter(Builder::extractDocId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtractDocId").build()}).build();
    private static final SdkField<String> DOCS_TO_INVESTIGATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MongoDbSettings.getter(MongoDbSettings::docsToInvestigate)).setter(MongoDbSettings.setter(Builder::docsToInvestigate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocsToInvestigate").build()}).build();
    private static final SdkField<String> AUTH_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MongoDbSettings.getter(MongoDbSettings::authSource)).setter(MongoDbSettings.setter(Builder::authSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthSource").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MongoDbSettings.getter(MongoDbSettings::kmsKeyId)).setter(MongoDbSettings.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERNAME_FIELD, PASSWORD_FIELD, SERVER_NAME_FIELD, PORT_FIELD, DATABASE_NAME_FIELD, AUTH_TYPE_FIELD, AUTH_MECHANISM_FIELD, NESTING_LEVEL_FIELD, EXTRACT_DOC_ID_FIELD, DOCS_TO_INVESTIGATE_FIELD, AUTH_SOURCE_FIELD, KMS_KEY_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String username;
    private final String password;
    private final String serverName;
    private final Integer port;
    private final String databaseName;
    private final String authType;
    private final String authMechanism;
    private final String nestingLevel;
    private final String extractDocId;
    private final String docsToInvestigate;
    private final String authSource;
    private final String kmsKeyId;

    private MongoDbSettings(BuilderImpl builder) {
        this.username = builder.username;
        this.password = builder.password;
        this.serverName = builder.serverName;
        this.port = builder.port;
        this.databaseName = builder.databaseName;
        this.authType = builder.authType;
        this.authMechanism = builder.authMechanism;
        this.nestingLevel = builder.nestingLevel;
        this.extractDocId = builder.extractDocId;
        this.docsToInvestigate = builder.docsToInvestigate;
        this.authSource = builder.authSource;
        this.kmsKeyId = builder.kmsKeyId;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public String serverName() {
        return this.serverName;
    }

    public Integer port() {
        return this.port;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public AuthTypeValue authType() {
        return AuthTypeValue.fromValue(this.authType);
    }

    public String authTypeAsString() {
        return this.authType;
    }

    public AuthMechanismValue authMechanism() {
        return AuthMechanismValue.fromValue(this.authMechanism);
    }

    public String authMechanismAsString() {
        return this.authMechanism;
    }

    public NestingLevelValue nestingLevel() {
        return NestingLevelValue.fromValue(this.nestingLevel);
    }

    public String nestingLevelAsString() {
        return this.nestingLevel;
    }

    public String extractDocId() {
        return this.extractDocId;
    }

    public String docsToInvestigate() {
        return this.docsToInvestigate;
    }

    public String authSource() {
        return this.authSource;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverName());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.authMechanismAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nestingLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.extractDocId());
        hashCode = 31 * hashCode + Objects.hashCode(this.docsToInvestigate());
        hashCode = 31 * hashCode + Objects.hashCode(this.authSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MongoDbSettings)) {
            return false;
        }
        MongoDbSettings other = (MongoDbSettings)obj;
        return Objects.equals(this.username(), other.username()) && Objects.equals(this.password(), other.password()) && Objects.equals(this.serverName(), other.serverName()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.authTypeAsString(), other.authTypeAsString()) && Objects.equals(this.authMechanismAsString(), other.authMechanismAsString()) && Objects.equals(this.nestingLevelAsString(), other.nestingLevelAsString()) && Objects.equals(this.extractDocId(), other.extractDocId()) && Objects.equals(this.docsToInvestigate(), other.docsToInvestigate()) && Objects.equals(this.authSource(), other.authSource()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId());
    }

    public String toString() {
        return ToString.builder((String)"MongoDbSettings").add("Username", (Object)this.username()).add("Password", (Object)this.password()).add("ServerName", (Object)this.serverName()).add("Port", (Object)this.port()).add("DatabaseName", (Object)this.databaseName()).add("AuthType", (Object)this.authTypeAsString()).add("AuthMechanism", (Object)this.authMechanismAsString()).add("NestingLevel", (Object)this.nestingLevelAsString()).add("ExtractDocId", (Object)this.extractDocId()).add("DocsToInvestigate", (Object)this.docsToInvestigate()).add("AuthSource", (Object)this.authSource()).add("KmsKeyId", (Object)this.kmsKeyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "Password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
            case "ServerName": {
                return Optional.ofNullable(clazz.cast(this.serverName()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "AuthType": {
                return Optional.ofNullable(clazz.cast(this.authTypeAsString()));
            }
            case "AuthMechanism": {
                return Optional.ofNullable(clazz.cast(this.authMechanismAsString()));
            }
            case "NestingLevel": {
                return Optional.ofNullable(clazz.cast(this.nestingLevelAsString()));
            }
            case "ExtractDocId": {
                return Optional.ofNullable(clazz.cast(this.extractDocId()));
            }
            case "DocsToInvestigate": {
                return Optional.ofNullable(clazz.cast(this.docsToInvestigate()));
            }
            case "AuthSource": {
                return Optional.ofNullable(clazz.cast(this.authSource()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MongoDbSettings, T> g) {
        return obj -> g.apply((MongoDbSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String username;
        private String password;
        private String serverName;
        private Integer port;
        private String databaseName;
        private String authType;
        private String authMechanism;
        private String nestingLevel;
        private String extractDocId;
        private String docsToInvestigate;
        private String authSource;
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(MongoDbSettings model) {
            this.username(model.username);
            this.password(model.password);
            this.serverName(model.serverName);
            this.port(model.port);
            this.databaseName(model.databaseName);
            this.authType(model.authType);
            this.authMechanism(model.authMechanism);
            this.nestingLevel(model.nestingLevel);
            this.extractDocId(model.extractDocId);
            this.docsToInvestigate(model.docsToInvestigate);
            this.authSource(model.authSource);
            this.kmsKeyId(model.kmsKeyId);
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getPassword() {
            return this.password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final String getServerName() {
            return this.serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getAuthTypeAsString() {
            return this.authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(AuthTypeValue authType) {
            this.authType(authType.toString());
            return this;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        public final String getAuthMechanismAsString() {
            return this.authMechanism;
        }

        @Override
        public final Builder authMechanism(String authMechanism) {
            this.authMechanism = authMechanism;
            return this;
        }

        @Override
        public final Builder authMechanism(AuthMechanismValue authMechanism) {
            this.authMechanism(authMechanism.toString());
            return this;
        }

        public final void setAuthMechanism(String authMechanism) {
            this.authMechanism = authMechanism;
        }

        public final String getNestingLevelAsString() {
            return this.nestingLevel;
        }

        @Override
        public final Builder nestingLevel(String nestingLevel) {
            this.nestingLevel = nestingLevel;
            return this;
        }

        @Override
        public final Builder nestingLevel(NestingLevelValue nestingLevel) {
            this.nestingLevel(nestingLevel.toString());
            return this;
        }

        public final void setNestingLevel(String nestingLevel) {
            this.nestingLevel = nestingLevel;
        }

        public final String getExtractDocId() {
            return this.extractDocId;
        }

        @Override
        public final Builder extractDocId(String extractDocId) {
            this.extractDocId = extractDocId;
            return this;
        }

        public final void setExtractDocId(String extractDocId) {
            this.extractDocId = extractDocId;
        }

        public final String getDocsToInvestigate() {
            return this.docsToInvestigate;
        }

        @Override
        public final Builder docsToInvestigate(String docsToInvestigate) {
            this.docsToInvestigate = docsToInvestigate;
            return this;
        }

        public final void setDocsToInvestigate(String docsToInvestigate) {
            this.docsToInvestigate = docsToInvestigate;
        }

        public final String getAuthSource() {
            return this.authSource;
        }

        @Override
        public final Builder authSource(String authSource) {
            this.authSource = authSource;
            return this;
        }

        public final void setAuthSource(String authSource) {
            this.authSource = authSource;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public MongoDbSettings build() {
            return new MongoDbSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MongoDbSettings> {
        public Builder username(String var1);

        public Builder password(String var1);

        public Builder serverName(String var1);

        public Builder port(Integer var1);

        public Builder databaseName(String var1);

        public Builder authType(String var1);

        public Builder authType(AuthTypeValue var1);

        public Builder authMechanism(String var1);

        public Builder authMechanism(AuthMechanismValue var1);

        public Builder nestingLevel(String var1);

        public Builder nestingLevel(NestingLevelValue var1);

        public Builder extractDocId(String var1);

        public Builder docsToInvestigate(String var1);

        public Builder authSource(String var1);

        public Builder kmsKeyId(String var1);
    }
}

