/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.MigrationTypeValue;
import software.amazon.awssdk.services.databasemigration.model.ReplicationTaskStats;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicationTask
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplicationTask> {
    private static final SdkField<String> REPLICATION_TASK_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationTaskIdentifier").getter(ReplicationTask.getter(ReplicationTask::replicationTaskIdentifier)).setter(ReplicationTask.setter(Builder::replicationTaskIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskIdentifier").build()}).build();
    private static final SdkField<String> SOURCE_ENDPOINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceEndpointArn").getter(ReplicationTask.getter(ReplicationTask::sourceEndpointArn)).setter(ReplicationTask.setter(Builder::sourceEndpointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEndpointArn").build()}).build();
    private static final SdkField<String> TARGET_ENDPOINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetEndpointArn").getter(ReplicationTask.getter(ReplicationTask::targetEndpointArn)).setter(ReplicationTask.setter(Builder::targetEndpointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetEndpointArn").build()}).build();
    private static final SdkField<String> REPLICATION_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationInstanceArn").getter(ReplicationTask.getter(ReplicationTask::replicationInstanceArn)).setter(ReplicationTask.setter(Builder::replicationInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceArn").build()}).build();
    private static final SdkField<String> MIGRATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MigrationType").getter(ReplicationTask.getter(ReplicationTask::migrationTypeAsString)).setter(ReplicationTask.setter(Builder::migrationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationType").build()}).build();
    private static final SdkField<String> TABLE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableMappings").getter(ReplicationTask.getter(ReplicationTask::tableMappings)).setter(ReplicationTask.setter(Builder::tableMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableMappings").build()}).build();
    private static final SdkField<String> REPLICATION_TASK_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationTaskSettings").getter(ReplicationTask.getter(ReplicationTask::replicationTaskSettings)).setter(ReplicationTask.setter(Builder::replicationTaskSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskSettings").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ReplicationTask.getter(ReplicationTask::status)).setter(ReplicationTask.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> LAST_FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastFailureMessage").getter(ReplicationTask.getter(ReplicationTask::lastFailureMessage)).setter(ReplicationTask.setter(Builder::lastFailureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastFailureMessage").build()}).build();
    private static final SdkField<String> STOP_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StopReason").getter(ReplicationTask.getter(ReplicationTask::stopReason)).setter(ReplicationTask.setter(Builder::stopReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StopReason").build()}).build();
    private static final SdkField<Instant> REPLICATION_TASK_CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ReplicationTaskCreationDate").getter(ReplicationTask.getter(ReplicationTask::replicationTaskCreationDate)).setter(ReplicationTask.setter(Builder::replicationTaskCreationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskCreationDate").build()}).build();
    private static final SdkField<Instant> REPLICATION_TASK_START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ReplicationTaskStartDate").getter(ReplicationTask.getter(ReplicationTask::replicationTaskStartDate)).setter(ReplicationTask.setter(Builder::replicationTaskStartDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskStartDate").build()}).build();
    private static final SdkField<String> CDC_START_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CdcStartPosition").getter(ReplicationTask.getter(ReplicationTask::cdcStartPosition)).setter(ReplicationTask.setter(Builder::cdcStartPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcStartPosition").build()}).build();
    private static final SdkField<String> CDC_STOP_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CdcStopPosition").getter(ReplicationTask.getter(ReplicationTask::cdcStopPosition)).setter(ReplicationTask.setter(Builder::cdcStopPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcStopPosition").build()}).build();
    private static final SdkField<String> RECOVERY_CHECKPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecoveryCheckpoint").getter(ReplicationTask.getter(ReplicationTask::recoveryCheckpoint)).setter(ReplicationTask.setter(Builder::recoveryCheckpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryCheckpoint").build()}).build();
    private static final SdkField<String> REPLICATION_TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationTaskArn").getter(ReplicationTask.getter(ReplicationTask::replicationTaskArn)).setter(ReplicationTask.setter(Builder::replicationTaskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskArn").build()}).build();
    private static final SdkField<ReplicationTaskStats> REPLICATION_TASK_STATS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReplicationTaskStats").getter(ReplicationTask.getter(ReplicationTask::replicationTaskStats)).setter(ReplicationTask.setter(Builder::replicationTaskStats)).constructor(ReplicationTaskStats::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskStats").build()}).build();
    private static final SdkField<String> TASK_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskData").getter(ReplicationTask.getter(ReplicationTask::taskData)).setter(ReplicationTask.setter(Builder::taskData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskData").build()}).build();
    private static final SdkField<String> TARGET_REPLICATION_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetReplicationInstanceArn").getter(ReplicationTask.getter(ReplicationTask::targetReplicationInstanceArn)).setter(ReplicationTask.setter(Builder::targetReplicationInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetReplicationInstanceArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_TASK_IDENTIFIER_FIELD, SOURCE_ENDPOINT_ARN_FIELD, TARGET_ENDPOINT_ARN_FIELD, REPLICATION_INSTANCE_ARN_FIELD, MIGRATION_TYPE_FIELD, TABLE_MAPPINGS_FIELD, REPLICATION_TASK_SETTINGS_FIELD, STATUS_FIELD, LAST_FAILURE_MESSAGE_FIELD, STOP_REASON_FIELD, REPLICATION_TASK_CREATION_DATE_FIELD, REPLICATION_TASK_START_DATE_FIELD, CDC_START_POSITION_FIELD, CDC_STOP_POSITION_FIELD, RECOVERY_CHECKPOINT_FIELD, REPLICATION_TASK_ARN_FIELD, REPLICATION_TASK_STATS_FIELD, TASK_DATA_FIELD, TARGET_REPLICATION_INSTANCE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ReplicationTaskIdentifier", REPLICATION_TASK_IDENTIFIER_FIELD);
            this.put("SourceEndpointArn", SOURCE_ENDPOINT_ARN_FIELD);
            this.put("TargetEndpointArn", TARGET_ENDPOINT_ARN_FIELD);
            this.put("ReplicationInstanceArn", REPLICATION_INSTANCE_ARN_FIELD);
            this.put("MigrationType", MIGRATION_TYPE_FIELD);
            this.put("TableMappings", TABLE_MAPPINGS_FIELD);
            this.put("ReplicationTaskSettings", REPLICATION_TASK_SETTINGS_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("LastFailureMessage", LAST_FAILURE_MESSAGE_FIELD);
            this.put("StopReason", STOP_REASON_FIELD);
            this.put("ReplicationTaskCreationDate", REPLICATION_TASK_CREATION_DATE_FIELD);
            this.put("ReplicationTaskStartDate", REPLICATION_TASK_START_DATE_FIELD);
            this.put("CdcStartPosition", CDC_START_POSITION_FIELD);
            this.put("CdcStopPosition", CDC_STOP_POSITION_FIELD);
            this.put("RecoveryCheckpoint", RECOVERY_CHECKPOINT_FIELD);
            this.put("ReplicationTaskArn", REPLICATION_TASK_ARN_FIELD);
            this.put("ReplicationTaskStats", REPLICATION_TASK_STATS_FIELD);
            this.put("TaskData", TASK_DATA_FIELD);
            this.put("TargetReplicationInstanceArn", TARGET_REPLICATION_INSTANCE_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String replicationTaskIdentifier;
    private final String sourceEndpointArn;
    private final String targetEndpointArn;
    private final String replicationInstanceArn;
    private final String migrationType;
    private final String tableMappings;
    private final String replicationTaskSettings;
    private final String status;
    private final String lastFailureMessage;
    private final String stopReason;
    private final Instant replicationTaskCreationDate;
    private final Instant replicationTaskStartDate;
    private final String cdcStartPosition;
    private final String cdcStopPosition;
    private final String recoveryCheckpoint;
    private final String replicationTaskArn;
    private final ReplicationTaskStats replicationTaskStats;
    private final String taskData;
    private final String targetReplicationInstanceArn;

    private ReplicationTask(BuilderImpl builder) {
        this.replicationTaskIdentifier = builder.replicationTaskIdentifier;
        this.sourceEndpointArn = builder.sourceEndpointArn;
        this.targetEndpointArn = builder.targetEndpointArn;
        this.replicationInstanceArn = builder.replicationInstanceArn;
        this.migrationType = builder.migrationType;
        this.tableMappings = builder.tableMappings;
        this.replicationTaskSettings = builder.replicationTaskSettings;
        this.status = builder.status;
        this.lastFailureMessage = builder.lastFailureMessage;
        this.stopReason = builder.stopReason;
        this.replicationTaskCreationDate = builder.replicationTaskCreationDate;
        this.replicationTaskStartDate = builder.replicationTaskStartDate;
        this.cdcStartPosition = builder.cdcStartPosition;
        this.cdcStopPosition = builder.cdcStopPosition;
        this.recoveryCheckpoint = builder.recoveryCheckpoint;
        this.replicationTaskArn = builder.replicationTaskArn;
        this.replicationTaskStats = builder.replicationTaskStats;
        this.taskData = builder.taskData;
        this.targetReplicationInstanceArn = builder.targetReplicationInstanceArn;
    }

    public final String replicationTaskIdentifier() {
        return this.replicationTaskIdentifier;
    }

    public final String sourceEndpointArn() {
        return this.sourceEndpointArn;
    }

    public final String targetEndpointArn() {
        return this.targetEndpointArn;
    }

    public final String replicationInstanceArn() {
        return this.replicationInstanceArn;
    }

    public final MigrationTypeValue migrationType() {
        return MigrationTypeValue.fromValue(this.migrationType);
    }

    public final String migrationTypeAsString() {
        return this.migrationType;
    }

    public final String tableMappings() {
        return this.tableMappings;
    }

    public final String replicationTaskSettings() {
        return this.replicationTaskSettings;
    }

    public final String status() {
        return this.status;
    }

    public final String lastFailureMessage() {
        return this.lastFailureMessage;
    }

    public final String stopReason() {
        return this.stopReason;
    }

    public final Instant replicationTaskCreationDate() {
        return this.replicationTaskCreationDate;
    }

    public final Instant replicationTaskStartDate() {
        return this.replicationTaskStartDate;
    }

    public final String cdcStartPosition() {
        return this.cdcStartPosition;
    }

    public final String cdcStopPosition() {
        return this.cdcStopPosition;
    }

    public final String recoveryCheckpoint() {
        return this.recoveryCheckpoint;
    }

    public final String replicationTaskArn() {
        return this.replicationTaskArn;
    }

    public final ReplicationTaskStats replicationTaskStats() {
        return this.replicationTaskStats;
    }

    public final String taskData() {
        return this.taskData;
    }

    public final String targetReplicationInstanceArn() {
        return this.targetReplicationInstanceArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationTaskIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEndpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetEndpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableMappings());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationTaskSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastFailureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationTaskCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationTaskStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.cdcStartPosition());
        hashCode = 31 * hashCode + Objects.hashCode(this.cdcStopPosition());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryCheckpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationTaskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationTaskStats());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskData());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetReplicationInstanceArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationTask)) {
            return false;
        }
        ReplicationTask other = (ReplicationTask)obj;
        return Objects.equals(this.replicationTaskIdentifier(), other.replicationTaskIdentifier()) && Objects.equals(this.sourceEndpointArn(), other.sourceEndpointArn()) && Objects.equals(this.targetEndpointArn(), other.targetEndpointArn()) && Objects.equals(this.replicationInstanceArn(), other.replicationInstanceArn()) && Objects.equals(this.migrationTypeAsString(), other.migrationTypeAsString()) && Objects.equals(this.tableMappings(), other.tableMappings()) && Objects.equals(this.replicationTaskSettings(), other.replicationTaskSettings()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.lastFailureMessage(), other.lastFailureMessage()) && Objects.equals(this.stopReason(), other.stopReason()) && Objects.equals(this.replicationTaskCreationDate(), other.replicationTaskCreationDate()) && Objects.equals(this.replicationTaskStartDate(), other.replicationTaskStartDate()) && Objects.equals(this.cdcStartPosition(), other.cdcStartPosition()) && Objects.equals(this.cdcStopPosition(), other.cdcStopPosition()) && Objects.equals(this.recoveryCheckpoint(), other.recoveryCheckpoint()) && Objects.equals(this.replicationTaskArn(), other.replicationTaskArn()) && Objects.equals(this.replicationTaskStats(), other.replicationTaskStats()) && Objects.equals(this.taskData(), other.taskData()) && Objects.equals(this.targetReplicationInstanceArn(), other.targetReplicationInstanceArn());
    }

    public final String toString() {
        return ToString.builder((String)"ReplicationTask").add("ReplicationTaskIdentifier", (Object)this.replicationTaskIdentifier()).add("SourceEndpointArn", (Object)this.sourceEndpointArn()).add("TargetEndpointArn", (Object)this.targetEndpointArn()).add("ReplicationInstanceArn", (Object)this.replicationInstanceArn()).add("MigrationType", (Object)this.migrationTypeAsString()).add("TableMappings", (Object)this.tableMappings()).add("ReplicationTaskSettings", (Object)this.replicationTaskSettings()).add("Status", (Object)this.status()).add("LastFailureMessage", (Object)this.lastFailureMessage()).add("StopReason", (Object)this.stopReason()).add("ReplicationTaskCreationDate", (Object)this.replicationTaskCreationDate()).add("ReplicationTaskStartDate", (Object)this.replicationTaskStartDate()).add("CdcStartPosition", (Object)this.cdcStartPosition()).add("CdcStopPosition", (Object)this.cdcStopPosition()).add("RecoveryCheckpoint", (Object)this.recoveryCheckpoint()).add("ReplicationTaskArn", (Object)this.replicationTaskArn()).add("ReplicationTaskStats", (Object)this.replicationTaskStats()).add("TaskData", (Object)this.taskData()).add("TargetReplicationInstanceArn", (Object)this.targetReplicationInstanceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationTaskIdentifier": {
                return Optional.ofNullable(clazz.cast(this.replicationTaskIdentifier()));
            }
            case "SourceEndpointArn": {
                return Optional.ofNullable(clazz.cast(this.sourceEndpointArn()));
            }
            case "TargetEndpointArn": {
                return Optional.ofNullable(clazz.cast(this.targetEndpointArn()));
            }
            case "ReplicationInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.replicationInstanceArn()));
            }
            case "MigrationType": {
                return Optional.ofNullable(clazz.cast(this.migrationTypeAsString()));
            }
            case "TableMappings": {
                return Optional.ofNullable(clazz.cast(this.tableMappings()));
            }
            case "ReplicationTaskSettings": {
                return Optional.ofNullable(clazz.cast(this.replicationTaskSettings()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "LastFailureMessage": {
                return Optional.ofNullable(clazz.cast(this.lastFailureMessage()));
            }
            case "StopReason": {
                return Optional.ofNullable(clazz.cast(this.stopReason()));
            }
            case "ReplicationTaskCreationDate": {
                return Optional.ofNullable(clazz.cast(this.replicationTaskCreationDate()));
            }
            case "ReplicationTaskStartDate": {
                return Optional.ofNullable(clazz.cast(this.replicationTaskStartDate()));
            }
            case "CdcStartPosition": {
                return Optional.ofNullable(clazz.cast(this.cdcStartPosition()));
            }
            case "CdcStopPosition": {
                return Optional.ofNullable(clazz.cast(this.cdcStopPosition()));
            }
            case "RecoveryCheckpoint": {
                return Optional.ofNullable(clazz.cast(this.recoveryCheckpoint()));
            }
            case "ReplicationTaskArn": {
                return Optional.ofNullable(clazz.cast(this.replicationTaskArn()));
            }
            case "ReplicationTaskStats": {
                return Optional.ofNullable(clazz.cast(this.replicationTaskStats()));
            }
            case "TaskData": {
                return Optional.ofNullable(clazz.cast(this.taskData()));
            }
            case "TargetReplicationInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.targetReplicationInstanceArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationTask, T> g) {
        return obj -> g.apply((ReplicationTask)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String replicationTaskIdentifier;
        private String sourceEndpointArn;
        private String targetEndpointArn;
        private String replicationInstanceArn;
        private String migrationType;
        private String tableMappings;
        private String replicationTaskSettings;
        private String status;
        private String lastFailureMessage;
        private String stopReason;
        private Instant replicationTaskCreationDate;
        private Instant replicationTaskStartDate;
        private String cdcStartPosition;
        private String cdcStopPosition;
        private String recoveryCheckpoint;
        private String replicationTaskArn;
        private ReplicationTaskStats replicationTaskStats;
        private String taskData;
        private String targetReplicationInstanceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationTask model) {
            this.replicationTaskIdentifier(model.replicationTaskIdentifier);
            this.sourceEndpointArn(model.sourceEndpointArn);
            this.targetEndpointArn(model.targetEndpointArn);
            this.replicationInstanceArn(model.replicationInstanceArn);
            this.migrationType(model.migrationType);
            this.tableMappings(model.tableMappings);
            this.replicationTaskSettings(model.replicationTaskSettings);
            this.status(model.status);
            this.lastFailureMessage(model.lastFailureMessage);
            this.stopReason(model.stopReason);
            this.replicationTaskCreationDate(model.replicationTaskCreationDate);
            this.replicationTaskStartDate(model.replicationTaskStartDate);
            this.cdcStartPosition(model.cdcStartPosition);
            this.cdcStopPosition(model.cdcStopPosition);
            this.recoveryCheckpoint(model.recoveryCheckpoint);
            this.replicationTaskArn(model.replicationTaskArn);
            this.replicationTaskStats(model.replicationTaskStats);
            this.taskData(model.taskData);
            this.targetReplicationInstanceArn(model.targetReplicationInstanceArn);
        }

        public final String getReplicationTaskIdentifier() {
            return this.replicationTaskIdentifier;
        }

        public final void setReplicationTaskIdentifier(String replicationTaskIdentifier) {
            this.replicationTaskIdentifier = replicationTaskIdentifier;
        }

        @Override
        public final Builder replicationTaskIdentifier(String replicationTaskIdentifier) {
            this.replicationTaskIdentifier = replicationTaskIdentifier;
            return this;
        }

        public final String getSourceEndpointArn() {
            return this.sourceEndpointArn;
        }

        public final void setSourceEndpointArn(String sourceEndpointArn) {
            this.sourceEndpointArn = sourceEndpointArn;
        }

        @Override
        public final Builder sourceEndpointArn(String sourceEndpointArn) {
            this.sourceEndpointArn = sourceEndpointArn;
            return this;
        }

        public final String getTargetEndpointArn() {
            return this.targetEndpointArn;
        }

        public final void setTargetEndpointArn(String targetEndpointArn) {
            this.targetEndpointArn = targetEndpointArn;
        }

        @Override
        public final Builder targetEndpointArn(String targetEndpointArn) {
            this.targetEndpointArn = targetEndpointArn;
            return this;
        }

        public final String getReplicationInstanceArn() {
            return this.replicationInstanceArn;
        }

        public final void setReplicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
        }

        @Override
        public final Builder replicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
            return this;
        }

        public final String getMigrationType() {
            return this.migrationType;
        }

        public final void setMigrationType(String migrationType) {
            this.migrationType = migrationType;
        }

        @Override
        public final Builder migrationType(String migrationType) {
            this.migrationType = migrationType;
            return this;
        }

        @Override
        public final Builder migrationType(MigrationTypeValue migrationType) {
            this.migrationType(migrationType == null ? null : migrationType.toString());
            return this;
        }

        public final String getTableMappings() {
            return this.tableMappings;
        }

        public final void setTableMappings(String tableMappings) {
            this.tableMappings = tableMappings;
        }

        @Override
        public final Builder tableMappings(String tableMappings) {
            this.tableMappings = tableMappings;
            return this;
        }

        public final String getReplicationTaskSettings() {
            return this.replicationTaskSettings;
        }

        public final void setReplicationTaskSettings(String replicationTaskSettings) {
            this.replicationTaskSettings = replicationTaskSettings;
        }

        @Override
        public final Builder replicationTaskSettings(String replicationTaskSettings) {
            this.replicationTaskSettings = replicationTaskSettings;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getLastFailureMessage() {
            return this.lastFailureMessage;
        }

        public final void setLastFailureMessage(String lastFailureMessage) {
            this.lastFailureMessage = lastFailureMessage;
        }

        @Override
        public final Builder lastFailureMessage(String lastFailureMessage) {
            this.lastFailureMessage = lastFailureMessage;
            return this;
        }

        public final String getStopReason() {
            return this.stopReason;
        }

        public final void setStopReason(String stopReason) {
            this.stopReason = stopReason;
        }

        @Override
        public final Builder stopReason(String stopReason) {
            this.stopReason = stopReason;
            return this;
        }

        public final Instant getReplicationTaskCreationDate() {
            return this.replicationTaskCreationDate;
        }

        public final void setReplicationTaskCreationDate(Instant replicationTaskCreationDate) {
            this.replicationTaskCreationDate = replicationTaskCreationDate;
        }

        @Override
        public final Builder replicationTaskCreationDate(Instant replicationTaskCreationDate) {
            this.replicationTaskCreationDate = replicationTaskCreationDate;
            return this;
        }

        public final Instant getReplicationTaskStartDate() {
            return this.replicationTaskStartDate;
        }

        public final void setReplicationTaskStartDate(Instant replicationTaskStartDate) {
            this.replicationTaskStartDate = replicationTaskStartDate;
        }

        @Override
        public final Builder replicationTaskStartDate(Instant replicationTaskStartDate) {
            this.replicationTaskStartDate = replicationTaskStartDate;
            return this;
        }

        public final String getCdcStartPosition() {
            return this.cdcStartPosition;
        }

        public final void setCdcStartPosition(String cdcStartPosition) {
            this.cdcStartPosition = cdcStartPosition;
        }

        @Override
        public final Builder cdcStartPosition(String cdcStartPosition) {
            this.cdcStartPosition = cdcStartPosition;
            return this;
        }

        public final String getCdcStopPosition() {
            return this.cdcStopPosition;
        }

        public final void setCdcStopPosition(String cdcStopPosition) {
            this.cdcStopPosition = cdcStopPosition;
        }

        @Override
        public final Builder cdcStopPosition(String cdcStopPosition) {
            this.cdcStopPosition = cdcStopPosition;
            return this;
        }

        public final String getRecoveryCheckpoint() {
            return this.recoveryCheckpoint;
        }

        public final void setRecoveryCheckpoint(String recoveryCheckpoint) {
            this.recoveryCheckpoint = recoveryCheckpoint;
        }

        @Override
        public final Builder recoveryCheckpoint(String recoveryCheckpoint) {
            this.recoveryCheckpoint = recoveryCheckpoint;
            return this;
        }

        public final String getReplicationTaskArn() {
            return this.replicationTaskArn;
        }

        public final void setReplicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
        }

        @Override
        public final Builder replicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
            return this;
        }

        public final ReplicationTaskStats.Builder getReplicationTaskStats() {
            return this.replicationTaskStats != null ? this.replicationTaskStats.toBuilder() : null;
        }

        public final void setReplicationTaskStats(ReplicationTaskStats.BuilderImpl replicationTaskStats) {
            this.replicationTaskStats = replicationTaskStats != null ? replicationTaskStats.build() : null;
        }

        @Override
        public final Builder replicationTaskStats(ReplicationTaskStats replicationTaskStats) {
            this.replicationTaskStats = replicationTaskStats;
            return this;
        }

        public final String getTaskData() {
            return this.taskData;
        }

        public final void setTaskData(String taskData) {
            this.taskData = taskData;
        }

        @Override
        public final Builder taskData(String taskData) {
            this.taskData = taskData;
            return this;
        }

        public final String getTargetReplicationInstanceArn() {
            return this.targetReplicationInstanceArn;
        }

        public final void setTargetReplicationInstanceArn(String targetReplicationInstanceArn) {
            this.targetReplicationInstanceArn = targetReplicationInstanceArn;
        }

        @Override
        public final Builder targetReplicationInstanceArn(String targetReplicationInstanceArn) {
            this.targetReplicationInstanceArn = targetReplicationInstanceArn;
            return this;
        }

        public ReplicationTask build() {
            return new ReplicationTask(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplicationTask> {
        public Builder replicationTaskIdentifier(String var1);

        public Builder sourceEndpointArn(String var1);

        public Builder targetEndpointArn(String var1);

        public Builder replicationInstanceArn(String var1);

        public Builder migrationType(String var1);

        public Builder migrationType(MigrationTypeValue var1);

        public Builder tableMappings(String var1);

        public Builder replicationTaskSettings(String var1);

        public Builder status(String var1);

        public Builder lastFailureMessage(String var1);

        public Builder stopReason(String var1);

        public Builder replicationTaskCreationDate(Instant var1);

        public Builder replicationTaskStartDate(Instant var1);

        public Builder cdcStartPosition(String var1);

        public Builder cdcStopPosition(String var1);

        public Builder recoveryCheckpoint(String var1);

        public Builder replicationTaskArn(String var1);

        public Builder replicationTaskStats(ReplicationTaskStats var1);

        default public Builder replicationTaskStats(Consumer<ReplicationTaskStats.Builder> replicationTaskStats) {
            return this.replicationTaskStats((ReplicationTaskStats)((ReplicationTaskStats.Builder)ReplicationTaskStats.builder().applyMutation(replicationTaskStats)).build());
        }

        public Builder taskData(String var1);

        public Builder targetReplicationInstanceArn(String var1);
    }
}

