/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartReplicationRequest
extends DatabaseMigrationRequest
implements ToCopyableBuilder<Builder, StartReplicationRequest> {
    private static final SdkField<String> REPLICATION_CONFIG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationConfigArn").getter(StartReplicationRequest.getter(StartReplicationRequest::replicationConfigArn)).setter(StartReplicationRequest.setter(Builder::replicationConfigArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationConfigArn").build()}).build();
    private static final SdkField<String> START_REPLICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartReplicationType").getter(StartReplicationRequest.getter(StartReplicationRequest::startReplicationType)).setter(StartReplicationRequest.setter(Builder::startReplicationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartReplicationType").build()}).build();
    private static final SdkField<Instant> CDC_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CdcStartTime").getter(StartReplicationRequest.getter(StartReplicationRequest::cdcStartTime)).setter(StartReplicationRequest.setter(Builder::cdcStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcStartTime").build()}).build();
    private static final SdkField<String> CDC_START_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CdcStartPosition").getter(StartReplicationRequest.getter(StartReplicationRequest::cdcStartPosition)).setter(StartReplicationRequest.setter(Builder::cdcStartPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcStartPosition").build()}).build();
    private static final SdkField<String> CDC_STOP_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CdcStopPosition").getter(StartReplicationRequest.getter(StartReplicationRequest::cdcStopPosition)).setter(StartReplicationRequest.setter(Builder::cdcStopPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcStopPosition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_CONFIG_ARN_FIELD, START_REPLICATION_TYPE_FIELD, CDC_START_TIME_FIELD, CDC_START_POSITION_FIELD, CDC_STOP_POSITION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ReplicationConfigArn", REPLICATION_CONFIG_ARN_FIELD);
            this.put("StartReplicationType", START_REPLICATION_TYPE_FIELD);
            this.put("CdcStartTime", CDC_START_TIME_FIELD);
            this.put("CdcStartPosition", CDC_START_POSITION_FIELD);
            this.put("CdcStopPosition", CDC_STOP_POSITION_FIELD);
        }
    });
    private final String replicationConfigArn;
    private final String startReplicationType;
    private final Instant cdcStartTime;
    private final String cdcStartPosition;
    private final String cdcStopPosition;

    private StartReplicationRequest(BuilderImpl builder) {
        super(builder);
        this.replicationConfigArn = builder.replicationConfigArn;
        this.startReplicationType = builder.startReplicationType;
        this.cdcStartTime = builder.cdcStartTime;
        this.cdcStartPosition = builder.cdcStartPosition;
        this.cdcStopPosition = builder.cdcStopPosition;
    }

    public final String replicationConfigArn() {
        return this.replicationConfigArn;
    }

    public final String startReplicationType() {
        return this.startReplicationType;
    }

    public final Instant cdcStartTime() {
        return this.cdcStartTime;
    }

    public final String cdcStartPosition() {
        return this.cdcStartPosition;
    }

    public final String cdcStopPosition() {
        return this.cdcStopPosition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.startReplicationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.cdcStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.cdcStartPosition());
        hashCode = 31 * hashCode + Objects.hashCode(this.cdcStopPosition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartReplicationRequest)) {
            return false;
        }
        StartReplicationRequest other = (StartReplicationRequest)((Object)obj);
        return Objects.equals(this.replicationConfigArn(), other.replicationConfigArn()) && Objects.equals(this.startReplicationType(), other.startReplicationType()) && Objects.equals(this.cdcStartTime(), other.cdcStartTime()) && Objects.equals(this.cdcStartPosition(), other.cdcStartPosition()) && Objects.equals(this.cdcStopPosition(), other.cdcStopPosition());
    }

    public final String toString() {
        return ToString.builder((String)"StartReplicationRequest").add("ReplicationConfigArn", (Object)this.replicationConfigArn()).add("StartReplicationType", (Object)this.startReplicationType()).add("CdcStartTime", (Object)this.cdcStartTime()).add("CdcStartPosition", (Object)this.cdcStartPosition()).add("CdcStopPosition", (Object)this.cdcStopPosition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationConfigArn": {
                return Optional.ofNullable(clazz.cast(this.replicationConfigArn()));
            }
            case "StartReplicationType": {
                return Optional.ofNullable(clazz.cast(this.startReplicationType()));
            }
            case "CdcStartTime": {
                return Optional.ofNullable(clazz.cast(this.cdcStartTime()));
            }
            case "CdcStartPosition": {
                return Optional.ofNullable(clazz.cast(this.cdcStartPosition()));
            }
            case "CdcStopPosition": {
                return Optional.ofNullable(clazz.cast(this.cdcStopPosition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartReplicationRequest, T> g) {
        return obj -> g.apply((StartReplicationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationRequest.BuilderImpl
    implements Builder {
        private String replicationConfigArn;
        private String startReplicationType;
        private Instant cdcStartTime;
        private String cdcStartPosition;
        private String cdcStopPosition;

        private BuilderImpl() {
        }

        private BuilderImpl(StartReplicationRequest model) {
            super(model);
            this.replicationConfigArn(model.replicationConfigArn);
            this.startReplicationType(model.startReplicationType);
            this.cdcStartTime(model.cdcStartTime);
            this.cdcStartPosition(model.cdcStartPosition);
            this.cdcStopPosition(model.cdcStopPosition);
        }

        public final String getReplicationConfigArn() {
            return this.replicationConfigArn;
        }

        public final void setReplicationConfigArn(String replicationConfigArn) {
            this.replicationConfigArn = replicationConfigArn;
        }

        @Override
        public final Builder replicationConfigArn(String replicationConfigArn) {
            this.replicationConfigArn = replicationConfigArn;
            return this;
        }

        public final String getStartReplicationType() {
            return this.startReplicationType;
        }

        public final void setStartReplicationType(String startReplicationType) {
            this.startReplicationType = startReplicationType;
        }

        @Override
        public final Builder startReplicationType(String startReplicationType) {
            this.startReplicationType = startReplicationType;
            return this;
        }

        public final Instant getCdcStartTime() {
            return this.cdcStartTime;
        }

        public final void setCdcStartTime(Instant cdcStartTime) {
            this.cdcStartTime = cdcStartTime;
        }

        @Override
        public final Builder cdcStartTime(Instant cdcStartTime) {
            this.cdcStartTime = cdcStartTime;
            return this;
        }

        public final String getCdcStartPosition() {
            return this.cdcStartPosition;
        }

        public final void setCdcStartPosition(String cdcStartPosition) {
            this.cdcStartPosition = cdcStartPosition;
        }

        @Override
        public final Builder cdcStartPosition(String cdcStartPosition) {
            this.cdcStartPosition = cdcStartPosition;
            return this;
        }

        public final String getCdcStopPosition() {
            return this.cdcStopPosition;
        }

        public final void setCdcStopPosition(String cdcStopPosition) {
            this.cdcStopPosition = cdcStopPosition;
        }

        @Override
        public final Builder cdcStopPosition(String cdcStopPosition) {
            this.cdcStopPosition = cdcStopPosition;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartReplicationRequest build() {
            return new StartReplicationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DatabaseMigrationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartReplicationRequest> {
        public Builder replicationConfigArn(String var1);

        public Builder startReplicationType(String var1);

        public Builder cdcStartTime(Instant var1);

        public Builder cdcStartPosition(String var1);

        public Builder cdcStopPosition(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

