/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.RecommendationSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartRecommendationsRequest
extends DatabaseMigrationRequest
implements ToCopyableBuilder<Builder, StartRecommendationsRequest> {
    private static final SdkField<String> DATABASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseId").getter(StartRecommendationsRequest.getter(StartRecommendationsRequest::databaseId)).setter(StartRecommendationsRequest.setter(Builder::databaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseId").build()}).build();
    private static final SdkField<RecommendationSettings> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Settings").getter(StartRecommendationsRequest.getter(StartRecommendationsRequest::settings)).setter(StartRecommendationsRequest.setter(Builder::settings)).constructor(RecommendationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_ID_FIELD, SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DatabaseId", DATABASE_ID_FIELD);
            this.put("Settings", SETTINGS_FIELD);
        }
    });
    private final String databaseId;
    private final RecommendationSettings settings;

    private StartRecommendationsRequest(BuilderImpl builder) {
        super(builder);
        this.databaseId = builder.databaseId;
        this.settings = builder.settings;
    }

    public final String databaseId() {
        return this.databaseId;
    }

    public final RecommendationSettings settings() {
        return this.settings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartRecommendationsRequest)) {
            return false;
        }
        StartRecommendationsRequest other = (StartRecommendationsRequest)((Object)obj);
        return Objects.equals(this.databaseId(), other.databaseId()) && Objects.equals(this.settings(), other.settings());
    }

    public final String toString() {
        return ToString.builder((String)"StartRecommendationsRequest").add("DatabaseId", (Object)this.databaseId()).add("Settings", (Object)this.settings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatabaseId": {
                return Optional.ofNullable(clazz.cast(this.databaseId()));
            }
            case "Settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartRecommendationsRequest, T> g) {
        return obj -> g.apply((StartRecommendationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationRequest.BuilderImpl
    implements Builder {
        private String databaseId;
        private RecommendationSettings settings;

        private BuilderImpl() {
        }

        private BuilderImpl(StartRecommendationsRequest model) {
            super(model);
            this.databaseId(model.databaseId);
            this.settings(model.settings);
        }

        public final String getDatabaseId() {
            return this.databaseId;
        }

        public final void setDatabaseId(String databaseId) {
            this.databaseId = databaseId;
        }

        @Override
        public final Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public final RecommendationSettings.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        public final void setSettings(RecommendationSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(RecommendationSettings settings) {
            this.settings = settings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartRecommendationsRequest build() {
            return new StartRecommendationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DatabaseMigrationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartRecommendationsRequest> {
        public Builder databaseId(String var1);

        public Builder settings(RecommendationSettings var1);

        default public Builder settings(Consumer<RecommendationSettings.Builder> settings) {
            return this.settings((RecommendationSettings)((RecommendationSettings.Builder)RecommendationSettings.builder().applyMutation(settings)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

