/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.DataProviderSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataProvider
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataProvider> {
    private static final SdkField<String> DATA_PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataProviderName").getter(DataProvider.getter(DataProvider::dataProviderName)).setter(DataProvider.setter(Builder::dataProviderName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataProviderName").build()}).build();
    private static final SdkField<String> DATA_PROVIDER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataProviderArn").getter(DataProvider.getter(DataProvider::dataProviderArn)).setter(DataProvider.setter(Builder::dataProviderArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataProviderArn").build()}).build();
    private static final SdkField<Instant> DATA_PROVIDER_CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DataProviderCreationTime").getter(DataProvider.getter(DataProvider::dataProviderCreationTime)).setter(DataProvider.setter(Builder::dataProviderCreationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataProviderCreationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DataProvider.getter(DataProvider::description)).setter(DataProvider.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(DataProvider.getter(DataProvider::engine)).setter(DataProvider.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<DataProviderSettings> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Settings").getter(DataProvider.getter(DataProvider::settings)).setter(DataProvider.setter(Builder::settings)).constructor(DataProviderSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_PROVIDER_NAME_FIELD, DATA_PROVIDER_ARN_FIELD, DATA_PROVIDER_CREATION_TIME_FIELD, DESCRIPTION_FIELD, ENGINE_FIELD, SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DataProviderName", DATA_PROVIDER_NAME_FIELD);
            this.put("DataProviderArn", DATA_PROVIDER_ARN_FIELD);
            this.put("DataProviderCreationTime", DATA_PROVIDER_CREATION_TIME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("Engine", ENGINE_FIELD);
            this.put("Settings", SETTINGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String dataProviderName;
    private final String dataProviderArn;
    private final Instant dataProviderCreationTime;
    private final String description;
    private final String engine;
    private final DataProviderSettings settings;

    private DataProvider(BuilderImpl builder) {
        this.dataProviderName = builder.dataProviderName;
        this.dataProviderArn = builder.dataProviderArn;
        this.dataProviderCreationTime = builder.dataProviderCreationTime;
        this.description = builder.description;
        this.engine = builder.engine;
        this.settings = builder.settings;
    }

    public final String dataProviderName() {
        return this.dataProviderName;
    }

    public final String dataProviderArn() {
        return this.dataProviderArn;
    }

    public final Instant dataProviderCreationTime() {
        return this.dataProviderCreationTime;
    }

    public final String description() {
        return this.description;
    }

    public final String engine() {
        return this.engine;
    }

    public final DataProviderSettings settings() {
        return this.settings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataProviderCreationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataProvider)) {
            return false;
        }
        DataProvider other = (DataProvider)obj;
        return Objects.equals(this.dataProviderName(), other.dataProviderName()) && Objects.equals(this.dataProviderArn(), other.dataProviderArn()) && Objects.equals(this.dataProviderCreationTime(), other.dataProviderCreationTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.settings(), other.settings());
    }

    public final String toString() {
        return ToString.builder((String)"DataProvider").add("DataProviderName", (Object)this.dataProviderName()).add("DataProviderArn", (Object)this.dataProviderArn()).add("DataProviderCreationTime", (Object)this.dataProviderCreationTime()).add("Description", (Object)this.description()).add("Engine", (Object)this.engine()).add("Settings", (Object)this.settings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataProviderName": {
                return Optional.ofNullable(clazz.cast(this.dataProviderName()));
            }
            case "DataProviderArn": {
                return Optional.ofNullable(clazz.cast(this.dataProviderArn()));
            }
            case "DataProviderCreationTime": {
                return Optional.ofNullable(clazz.cast(this.dataProviderCreationTime()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "Settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DataProvider, T> g) {
        return obj -> g.apply((DataProvider)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataProviderName;
        private String dataProviderArn;
        private Instant dataProviderCreationTime;
        private String description;
        private String engine;
        private DataProviderSettings settings;

        private BuilderImpl() {
        }

        private BuilderImpl(DataProvider model) {
            this.dataProviderName(model.dataProviderName);
            this.dataProviderArn(model.dataProviderArn);
            this.dataProviderCreationTime(model.dataProviderCreationTime);
            this.description(model.description);
            this.engine(model.engine);
            this.settings(model.settings);
        }

        public final String getDataProviderName() {
            return this.dataProviderName;
        }

        public final void setDataProviderName(String dataProviderName) {
            this.dataProviderName = dataProviderName;
        }

        @Override
        public final Builder dataProviderName(String dataProviderName) {
            this.dataProviderName = dataProviderName;
            return this;
        }

        public final String getDataProviderArn() {
            return this.dataProviderArn;
        }

        public final void setDataProviderArn(String dataProviderArn) {
            this.dataProviderArn = dataProviderArn;
        }

        @Override
        public final Builder dataProviderArn(String dataProviderArn) {
            this.dataProviderArn = dataProviderArn;
            return this;
        }

        public final Instant getDataProviderCreationTime() {
            return this.dataProviderCreationTime;
        }

        public final void setDataProviderCreationTime(Instant dataProviderCreationTime) {
            this.dataProviderCreationTime = dataProviderCreationTime;
        }

        @Override
        public final Builder dataProviderCreationTime(Instant dataProviderCreationTime) {
            this.dataProviderCreationTime = dataProviderCreationTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final DataProviderSettings.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        public final void setSettings(DataProviderSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(DataProviderSettings settings) {
            this.settings = settings;
            return this;
        }

        public DataProvider build() {
            return new DataProvider(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataProvider> {
        public Builder dataProviderName(String var1);

        public Builder dataProviderArn(String var1);

        public Builder dataProviderCreationTime(Instant var1);

        public Builder description(String var1);

        public Builder engine(String var1);

        public Builder settings(DataProviderSettings var1);

        default public Builder settings(Consumer<DataProviderSettings.Builder> settings) {
            return this.settings((DataProviderSettings)((DataProviderSettings.Builder)DataProviderSettings.builder().applyMutation(settings)).build());
        }
    }
}

