/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DataMigration;
import software.amazon.awssdk.services.databasemigration.model.DataMigrationsCopier;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDataMigrationsResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DescribeDataMigrationsResponse> {
    private static final SdkField<List<DataMigration>> DATA_MIGRATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataMigrations").getter(DescribeDataMigrationsResponse.getter(DescribeDataMigrationsResponse::dataMigrations)).setter(DescribeDataMigrationsResponse.setter(Builder::dataMigrations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataMigrations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataMigration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeDataMigrationsResponse.getter(DescribeDataMigrationsResponse::marker)).setter(DescribeDataMigrationsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_MIGRATIONS_FIELD, MARKER_FIELD));
    private final List<DataMigration> dataMigrations;
    private final String marker;

    private DescribeDataMigrationsResponse(BuilderImpl builder) {
        super(builder);
        this.dataMigrations = builder.dataMigrations;
        this.marker = builder.marker;
    }

    public final boolean hasDataMigrations() {
        return this.dataMigrations != null && !(this.dataMigrations instanceof SdkAutoConstructList);
    }

    public final List<DataMigration> dataMigrations() {
        return this.dataMigrations;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataMigrations() ? this.dataMigrations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDataMigrationsResponse)) {
            return false;
        }
        DescribeDataMigrationsResponse other = (DescribeDataMigrationsResponse)((Object)obj);
        return this.hasDataMigrations() == other.hasDataMigrations() && Objects.equals(this.dataMigrations(), other.dataMigrations()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDataMigrationsResponse").add("DataMigrations", this.hasDataMigrations() ? this.dataMigrations() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataMigrations": {
                return Optional.ofNullable(clazz.cast(this.dataMigrations()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDataMigrationsResponse, T> g) {
        return obj -> g.apply((DescribeDataMigrationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private List<DataMigration> dataMigrations = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDataMigrationsResponse model) {
            super(model);
            this.dataMigrations(model.dataMigrations);
            this.marker(model.marker);
        }

        public final List<DataMigration.Builder> getDataMigrations() {
            List<DataMigration.Builder> result = DataMigrationsCopier.copyToBuilder(this.dataMigrations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataMigrations(Collection<DataMigration.BuilderImpl> dataMigrations) {
            this.dataMigrations = DataMigrationsCopier.copyFromBuilder(dataMigrations);
        }

        @Override
        public final Builder dataMigrations(Collection<DataMigration> dataMigrations) {
            this.dataMigrations = DataMigrationsCopier.copy(dataMigrations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataMigrations(DataMigration ... dataMigrations) {
            this.dataMigrations(Arrays.asList(dataMigrations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataMigrations(Consumer<DataMigration.Builder> ... dataMigrations) {
            this.dataMigrations(Stream.of(dataMigrations).map(c -> (DataMigration)((DataMigration.Builder)DataMigration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeDataMigrationsResponse build() {
            return new DescribeDataMigrationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDataMigrationsResponse> {
        public Builder dataMigrations(Collection<DataMigration> var1);

        public Builder dataMigrations(DataMigration ... var1);

        public Builder dataMigrations(Consumer<DataMigration.Builder> ... var1);

        public Builder marker(String var1);
    }
}

