/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationAsyncClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationsResponse;

public class DescribeReplicationsPublisher
implements SdkPublisher<DescribeReplicationsResponse> {
    private final DatabaseMigrationAsyncClient client;
    private final DescribeReplicationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeReplicationsPublisher(DatabaseMigrationAsyncClient client, DescribeReplicationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeReplicationsPublisher(DatabaseMigrationAsyncClient client, DescribeReplicationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeReplicationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeReplicationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeReplicationsResponseFetcher
    implements AsyncPageFetcher<DescribeReplicationsResponse> {
        private DescribeReplicationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReplicationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeReplicationsResponse> nextPage(DescribeReplicationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReplicationsPublisher.this.client.describeReplications(DescribeReplicationsPublisher.this.firstRequest);
            }
            return DescribeReplicationsPublisher.this.client.describeReplications((DescribeReplicationsRequest)((Object)DescribeReplicationsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

