/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.AuthMechanismValue;
import software.amazon.awssdk.services.databasemigration.model.AuthTypeValue;
import software.amazon.awssdk.services.databasemigration.model.DmsSslModeValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MongoDbDataProviderSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MongoDbDataProviderSettings> {
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerName").getter(MongoDbDataProviderSettings.getter(MongoDbDataProviderSettings::serverName)).setter(MongoDbDataProviderSettings.setter(Builder::serverName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(MongoDbDataProviderSettings.getter(MongoDbDataProviderSettings::port)).setter(MongoDbDataProviderSettings.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(MongoDbDataProviderSettings.getter(MongoDbDataProviderSettings::databaseName)).setter(MongoDbDataProviderSettings.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> SSL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SslMode").getter(MongoDbDataProviderSettings.getter(MongoDbDataProviderSettings::sslModeAsString)).setter(MongoDbDataProviderSettings.setter(Builder::sslMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslMode").build()}).build();
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateArn").getter(MongoDbDataProviderSettings.getter(MongoDbDataProviderSettings::certificateArn)).setter(MongoDbDataProviderSettings.setter(Builder::certificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateArn").build()}).build();
    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthType").getter(MongoDbDataProviderSettings.getter(MongoDbDataProviderSettings::authTypeAsString)).setter(MongoDbDataProviderSettings.setter(Builder::authType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthType").build()}).build();
    private static final SdkField<String> AUTH_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthSource").getter(MongoDbDataProviderSettings.getter(MongoDbDataProviderSettings::authSource)).setter(MongoDbDataProviderSettings.setter(Builder::authSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthSource").build()}).build();
    private static final SdkField<String> AUTH_MECHANISM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthMechanism").getter(MongoDbDataProviderSettings.getter(MongoDbDataProviderSettings::authMechanismAsString)).setter(MongoDbDataProviderSettings.setter(Builder::authMechanism)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthMechanism").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_NAME_FIELD, PORT_FIELD, DATABASE_NAME_FIELD, SSL_MODE_FIELD, CERTIFICATE_ARN_FIELD, AUTH_TYPE_FIELD, AUTH_SOURCE_FIELD, AUTH_MECHANISM_FIELD));
    private static final long serialVersionUID = 1L;
    private final String serverName;
    private final Integer port;
    private final String databaseName;
    private final String sslMode;
    private final String certificateArn;
    private final String authType;
    private final String authSource;
    private final String authMechanism;

    private MongoDbDataProviderSettings(BuilderImpl builder) {
        this.serverName = builder.serverName;
        this.port = builder.port;
        this.databaseName = builder.databaseName;
        this.sslMode = builder.sslMode;
        this.certificateArn = builder.certificateArn;
        this.authType = builder.authType;
        this.authSource = builder.authSource;
        this.authMechanism = builder.authMechanism;
    }

    public final String serverName() {
        return this.serverName;
    }

    public final Integer port() {
        return this.port;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final DmsSslModeValue sslMode() {
        return DmsSslModeValue.fromValue(this.sslMode);
    }

    public final String sslModeAsString() {
        return this.sslMode;
    }

    public final String certificateArn() {
        return this.certificateArn;
    }

    public final AuthTypeValue authType() {
        return AuthTypeValue.fromValue(this.authType);
    }

    public final String authTypeAsString() {
        return this.authType;
    }

    public final String authSource() {
        return this.authSource;
    }

    public final AuthMechanismValue authMechanism() {
        return AuthMechanismValue.fromValue(this.authMechanism);
    }

    public final String authMechanismAsString() {
        return this.authMechanism;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serverName());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sslModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.authSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.authMechanismAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MongoDbDataProviderSettings)) {
            return false;
        }
        MongoDbDataProviderSettings other = (MongoDbDataProviderSettings)obj;
        return Objects.equals(this.serverName(), other.serverName()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.sslModeAsString(), other.sslModeAsString()) && Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.authTypeAsString(), other.authTypeAsString()) && Objects.equals(this.authSource(), other.authSource()) && Objects.equals(this.authMechanismAsString(), other.authMechanismAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MongoDbDataProviderSettings").add("ServerName", (Object)this.serverName()).add("Port", (Object)this.port()).add("DatabaseName", (Object)this.databaseName()).add("SslMode", (Object)this.sslModeAsString()).add("CertificateArn", (Object)this.certificateArn()).add("AuthType", (Object)this.authTypeAsString()).add("AuthSource", (Object)this.authSource()).add("AuthMechanism", (Object)this.authMechanismAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServerName": {
                return Optional.ofNullable(clazz.cast(this.serverName()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "SslMode": {
                return Optional.ofNullable(clazz.cast(this.sslModeAsString()));
            }
            case "CertificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "AuthType": {
                return Optional.ofNullable(clazz.cast(this.authTypeAsString()));
            }
            case "AuthSource": {
                return Optional.ofNullable(clazz.cast(this.authSource()));
            }
            case "AuthMechanism": {
                return Optional.ofNullable(clazz.cast(this.authMechanismAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MongoDbDataProviderSettings, T> g) {
        return obj -> g.apply((MongoDbDataProviderSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serverName;
        private Integer port;
        private String databaseName;
        private String sslMode;
        private String certificateArn;
        private String authType;
        private String authSource;
        private String authMechanism;

        private BuilderImpl() {
        }

        private BuilderImpl(MongoDbDataProviderSettings model) {
            this.serverName(model.serverName);
            this.port(model.port);
            this.databaseName(model.databaseName);
            this.sslMode(model.sslMode);
            this.certificateArn(model.certificateArn);
            this.authType(model.authType);
            this.authSource(model.authSource);
            this.authMechanism(model.authMechanism);
        }

        public final String getServerName() {
            return this.serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getSslMode() {
            return this.sslMode;
        }

        public final void setSslMode(String sslMode) {
            this.sslMode = sslMode;
        }

        @Override
        public final Builder sslMode(String sslMode) {
            this.sslMode = sslMode;
            return this;
        }

        @Override
        public final Builder sslMode(DmsSslModeValue sslMode) {
            this.sslMode(sslMode == null ? null : sslMode.toString());
            return this;
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final String getAuthType() {
            return this.authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(AuthTypeValue authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final String getAuthSource() {
            return this.authSource;
        }

        public final void setAuthSource(String authSource) {
            this.authSource = authSource;
        }

        @Override
        public final Builder authSource(String authSource) {
            this.authSource = authSource;
            return this;
        }

        public final String getAuthMechanism() {
            return this.authMechanism;
        }

        public final void setAuthMechanism(String authMechanism) {
            this.authMechanism = authMechanism;
        }

        @Override
        public final Builder authMechanism(String authMechanism) {
            this.authMechanism = authMechanism;
            return this;
        }

        @Override
        public final Builder authMechanism(AuthMechanismValue authMechanism) {
            this.authMechanism(authMechanism == null ? null : authMechanism.toString());
            return this;
        }

        public MongoDbDataProviderSettings build() {
            return new MongoDbDataProviderSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MongoDbDataProviderSettings> {
        public Builder serverName(String var1);

        public Builder port(Integer var1);

        public Builder databaseName(String var1);

        public Builder sslMode(String var1);

        public Builder sslMode(DmsSslModeValue var1);

        public Builder certificateArn(String var1);

        public Builder authType(String var1);

        public Builder authType(AuthTypeValue var1);

        public Builder authSource(String var1);

        public Builder authMechanism(String var1);

        public Builder authMechanism(AuthMechanismValue var1);
    }
}

