/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationAsyncClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeExtensionPackAssociationsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeExtensionPackAssociationsResponse;

public class DescribeExtensionPackAssociationsPublisher
implements SdkPublisher<DescribeExtensionPackAssociationsResponse> {
    private final DatabaseMigrationAsyncClient client;
    private final DescribeExtensionPackAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeExtensionPackAssociationsPublisher(DatabaseMigrationAsyncClient client, DescribeExtensionPackAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeExtensionPackAssociationsPublisher(DatabaseMigrationAsyncClient client, DescribeExtensionPackAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeExtensionPackAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeExtensionPackAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeExtensionPackAssociationsResponseFetcher
    implements AsyncPageFetcher<DescribeExtensionPackAssociationsResponse> {
        private DescribeExtensionPackAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeExtensionPackAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeExtensionPackAssociationsResponse> nextPage(DescribeExtensionPackAssociationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeExtensionPackAssociationsPublisher.this.client.describeExtensionPackAssociations(DescribeExtensionPackAssociationsPublisher.this.firstRequest);
            }
            return DescribeExtensionPackAssociationsPublisher.this.client.describeExtensionPackAssociations((DescribeExtensionPackAssociationsRequest)((Object)DescribeExtensionPackAssociationsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

