/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ReloadOptionValue {
    DATA_RELOAD("data-reload"),
    VALIDATE_ONLY("validate-only"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ReloadOptionValue> VALUE_MAP;
    private final String value;

    private ReloadOptionValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReloadOptionValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ReloadOptionValue> knownValues() {
        EnumSet<ReloadOptionValue> knownValues = EnumSet.allOf(ReloadOptionValue.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ReloadOptionValue.class, ReloadOptionValue::toString);
    }
}

