/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationAsyncClient;
import software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationsResponse;

public class DescribeRecommendationsPublisher
implements SdkPublisher<DescribeRecommendationsResponse> {
    private final DatabaseMigrationAsyncClient client;
    private final DescribeRecommendationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeRecommendationsPublisher(DatabaseMigrationAsyncClient client, DescribeRecommendationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeRecommendationsPublisher(DatabaseMigrationAsyncClient client, DescribeRecommendationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeRecommendationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeRecommendationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeRecommendationsResponseFetcher
    implements AsyncPageFetcher<DescribeRecommendationsResponse> {
        private DescribeRecommendationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRecommendationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeRecommendationsResponse> nextPage(DescribeRecommendationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeRecommendationsPublisher.this.client.describeRecommendations(DescribeRecommendationsPublisher.this.firstRequest);
            }
            return DescribeRecommendationsPublisher.this.client.describeRecommendations((DescribeRecommendationsRequest)((Object)DescribeRecommendationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

