/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationAsyncClient;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationAsyncClientBuilder;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationServiceClientConfiguration;
import software.amazon.awssdk.services.databasemigration.DefaultDatabaseMigrationAsyncClient;
import software.amazon.awssdk.services.databasemigration.DefaultDatabaseMigrationBaseClientBuilder;
import software.amazon.awssdk.services.databasemigration.endpoints.DatabaseMigrationEndpointProvider;

@SdkInternalApi
final class DefaultDatabaseMigrationAsyncClientBuilder
extends DefaultDatabaseMigrationBaseClientBuilder<DatabaseMigrationAsyncClientBuilder, DatabaseMigrationAsyncClient>
implements DatabaseMigrationAsyncClientBuilder {
    DefaultDatabaseMigrationAsyncClientBuilder() {
    }

    @Override
    public DefaultDatabaseMigrationAsyncClientBuilder endpointProvider(DatabaseMigrationEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DatabaseMigrationAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultDatabaseMigrationAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        DatabaseMigrationServiceClientConfiguration serviceClientConfiguration = DatabaseMigrationServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultDatabaseMigrationAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

