/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.databasemigration.model.MicrosoftSqlServerDataProviderSettings;
import software.amazon.awssdk.services.databasemigration.model.MySqlDataProviderSettings;
import software.amazon.awssdk.services.databasemigration.model.OracleDataProviderSettings;
import software.amazon.awssdk.services.databasemigration.model.PostgreSqlDataProviderSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataProviderSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataProviderSettings> {
    private static final SdkField<PostgreSqlDataProviderSettings> POSTGRE_SQL_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PostgreSqlSettings").getter(DataProviderSettings.getter(DataProviderSettings::postgreSqlSettings)).setter(DataProviderSettings.setter(Builder::postgreSqlSettings)).constructor(PostgreSqlDataProviderSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostgreSqlSettings").build()}).build();
    private static final SdkField<MySqlDataProviderSettings> MY_SQL_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MySqlSettings").getter(DataProviderSettings.getter(DataProviderSettings::mySqlSettings)).setter(DataProviderSettings.setter(Builder::mySqlSettings)).constructor(MySqlDataProviderSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MySqlSettings").build()}).build();
    private static final SdkField<OracleDataProviderSettings> ORACLE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OracleSettings").getter(DataProviderSettings.getter(DataProviderSettings::oracleSettings)).setter(DataProviderSettings.setter(Builder::oracleSettings)).constructor(OracleDataProviderSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OracleSettings").build()}).build();
    private static final SdkField<MicrosoftSqlServerDataProviderSettings> MICROSOFT_SQL_SERVER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MicrosoftSqlServerSettings").getter(DataProviderSettings.getter(DataProviderSettings::microsoftSqlServerSettings)).setter(DataProviderSettings.setter(Builder::microsoftSqlServerSettings)).constructor(MicrosoftSqlServerDataProviderSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MicrosoftSqlServerSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POSTGRE_SQL_SETTINGS_FIELD, MY_SQL_SETTINGS_FIELD, ORACLE_SETTINGS_FIELD, MICROSOFT_SQL_SERVER_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final PostgreSqlDataProviderSettings postgreSqlSettings;
    private final MySqlDataProviderSettings mySqlSettings;
    private final OracleDataProviderSettings oracleSettings;
    private final MicrosoftSqlServerDataProviderSettings microsoftSqlServerSettings;
    private final Type type;

    private DataProviderSettings(BuilderImpl builder) {
        this.postgreSqlSettings = builder.postgreSqlSettings;
        this.mySqlSettings = builder.mySqlSettings;
        this.oracleSettings = builder.oracleSettings;
        this.microsoftSqlServerSettings = builder.microsoftSqlServerSettings;
        this.type = builder.type;
    }

    public final PostgreSqlDataProviderSettings postgreSqlSettings() {
        return this.postgreSqlSettings;
    }

    public final MySqlDataProviderSettings mySqlSettings() {
        return this.mySqlSettings;
    }

    public final OracleDataProviderSettings oracleSettings() {
        return this.oracleSettings;
    }

    public final MicrosoftSqlServerDataProviderSettings microsoftSqlServerSettings() {
        return this.microsoftSqlServerSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.postgreSqlSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.mySqlSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.oracleSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.microsoftSqlServerSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataProviderSettings)) {
            return false;
        }
        DataProviderSettings other = (DataProviderSettings)obj;
        return Objects.equals(this.postgreSqlSettings(), other.postgreSqlSettings()) && Objects.equals(this.mySqlSettings(), other.mySqlSettings()) && Objects.equals(this.oracleSettings(), other.oracleSettings()) && Objects.equals(this.microsoftSqlServerSettings(), other.microsoftSqlServerSettings());
    }

    public final String toString() {
        return ToString.builder((String)"DataProviderSettings").add("PostgreSqlSettings", (Object)this.postgreSqlSettings()).add("MySqlSettings", (Object)this.mySqlSettings()).add("OracleSettings", (Object)this.oracleSettings()).add("MicrosoftSqlServerSettings", (Object)this.microsoftSqlServerSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PostgreSqlSettings": {
                return Optional.ofNullable(clazz.cast(this.postgreSqlSettings()));
            }
            case "MySqlSettings": {
                return Optional.ofNullable(clazz.cast(this.mySqlSettings()));
            }
            case "OracleSettings": {
                return Optional.ofNullable(clazz.cast(this.oracleSettings()));
            }
            case "MicrosoftSqlServerSettings": {
                return Optional.ofNullable(clazz.cast(this.microsoftSqlServerSettings()));
            }
        }
        return Optional.empty();
    }

    public static DataProviderSettings fromPostgreSqlSettings(PostgreSqlDataProviderSettings postgreSqlSettings) {
        return (DataProviderSettings)DataProviderSettings.builder().postgreSqlSettings(postgreSqlSettings).build();
    }

    public static DataProviderSettings fromPostgreSqlSettings(Consumer<PostgreSqlDataProviderSettings.Builder> postgreSqlSettings) {
        PostgreSqlDataProviderSettings.Builder builder = PostgreSqlDataProviderSettings.builder();
        postgreSqlSettings.accept(builder);
        return DataProviderSettings.fromPostgreSqlSettings((PostgreSqlDataProviderSettings)builder.build());
    }

    public static DataProviderSettings fromMySqlSettings(MySqlDataProviderSettings mySqlSettings) {
        return (DataProviderSettings)DataProviderSettings.builder().mySqlSettings(mySqlSettings).build();
    }

    public static DataProviderSettings fromMySqlSettings(Consumer<MySqlDataProviderSettings.Builder> mySqlSettings) {
        MySqlDataProviderSettings.Builder builder = MySqlDataProviderSettings.builder();
        mySqlSettings.accept(builder);
        return DataProviderSettings.fromMySqlSettings((MySqlDataProviderSettings)builder.build());
    }

    public static DataProviderSettings fromOracleSettings(OracleDataProviderSettings oracleSettings) {
        return (DataProviderSettings)DataProviderSettings.builder().oracleSettings(oracleSettings).build();
    }

    public static DataProviderSettings fromOracleSettings(Consumer<OracleDataProviderSettings.Builder> oracleSettings) {
        OracleDataProviderSettings.Builder builder = OracleDataProviderSettings.builder();
        oracleSettings.accept(builder);
        return DataProviderSettings.fromOracleSettings((OracleDataProviderSettings)builder.build());
    }

    public static DataProviderSettings fromMicrosoftSqlServerSettings(MicrosoftSqlServerDataProviderSettings microsoftSqlServerSettings) {
        return (DataProviderSettings)DataProviderSettings.builder().microsoftSqlServerSettings(microsoftSqlServerSettings).build();
    }

    public static DataProviderSettings fromMicrosoftSqlServerSettings(Consumer<MicrosoftSqlServerDataProviderSettings.Builder> microsoftSqlServerSettings) {
        MicrosoftSqlServerDataProviderSettings.Builder builder = MicrosoftSqlServerDataProviderSettings.builder();
        microsoftSqlServerSettings.accept(builder);
        return DataProviderSettings.fromMicrosoftSqlServerSettings((MicrosoftSqlServerDataProviderSettings)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataProviderSettings, T> g) {
        return obj -> g.apply((DataProviderSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        POSTGRE_SQL_SETTINGS,
        MY_SQL_SETTINGS,
        ORACLE_SETTINGS,
        MICROSOFT_SQL_SERVER_SETTINGS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private PostgreSqlDataProviderSettings postgreSqlSettings;
        private MySqlDataProviderSettings mySqlSettings;
        private OracleDataProviderSettings oracleSettings;
        private MicrosoftSqlServerDataProviderSettings microsoftSqlServerSettings;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DataProviderSettings model) {
            this.postgreSqlSettings(model.postgreSqlSettings);
            this.mySqlSettings(model.mySqlSettings);
            this.oracleSettings(model.oracleSettings);
            this.microsoftSqlServerSettings(model.microsoftSqlServerSettings);
        }

        public final PostgreSqlDataProviderSettings.Builder getPostgreSqlSettings() {
            return this.postgreSqlSettings != null ? this.postgreSqlSettings.toBuilder() : null;
        }

        public final void setPostgreSqlSettings(PostgreSqlDataProviderSettings.BuilderImpl postgreSqlSettings) {
            PostgreSqlDataProviderSettings oldValue = this.postgreSqlSettings;
            this.postgreSqlSettings = postgreSqlSettings != null ? postgreSqlSettings.build() : null;
            this.handleUnionValueChange(Type.POSTGRE_SQL_SETTINGS, oldValue, this.postgreSqlSettings);
        }

        @Override
        public final Builder postgreSqlSettings(PostgreSqlDataProviderSettings postgreSqlSettings) {
            PostgreSqlDataProviderSettings oldValue = this.postgreSqlSettings;
            this.postgreSqlSettings = postgreSqlSettings;
            this.handleUnionValueChange(Type.POSTGRE_SQL_SETTINGS, oldValue, this.postgreSqlSettings);
            return this;
        }

        public final MySqlDataProviderSettings.Builder getMySqlSettings() {
            return this.mySqlSettings != null ? this.mySqlSettings.toBuilder() : null;
        }

        public final void setMySqlSettings(MySqlDataProviderSettings.BuilderImpl mySqlSettings) {
            MySqlDataProviderSettings oldValue = this.mySqlSettings;
            this.mySqlSettings = mySqlSettings != null ? mySqlSettings.build() : null;
            this.handleUnionValueChange(Type.MY_SQL_SETTINGS, oldValue, this.mySqlSettings);
        }

        @Override
        public final Builder mySqlSettings(MySqlDataProviderSettings mySqlSettings) {
            MySqlDataProviderSettings oldValue = this.mySqlSettings;
            this.mySqlSettings = mySqlSettings;
            this.handleUnionValueChange(Type.MY_SQL_SETTINGS, oldValue, this.mySqlSettings);
            return this;
        }

        public final OracleDataProviderSettings.Builder getOracleSettings() {
            return this.oracleSettings != null ? this.oracleSettings.toBuilder() : null;
        }

        public final void setOracleSettings(OracleDataProviderSettings.BuilderImpl oracleSettings) {
            OracleDataProviderSettings oldValue = this.oracleSettings;
            this.oracleSettings = oracleSettings != null ? oracleSettings.build() : null;
            this.handleUnionValueChange(Type.ORACLE_SETTINGS, oldValue, this.oracleSettings);
        }

        @Override
        public final Builder oracleSettings(OracleDataProviderSettings oracleSettings) {
            OracleDataProviderSettings oldValue = this.oracleSettings;
            this.oracleSettings = oracleSettings;
            this.handleUnionValueChange(Type.ORACLE_SETTINGS, oldValue, this.oracleSettings);
            return this;
        }

        public final MicrosoftSqlServerDataProviderSettings.Builder getMicrosoftSqlServerSettings() {
            return this.microsoftSqlServerSettings != null ? this.microsoftSqlServerSettings.toBuilder() : null;
        }

        public final void setMicrosoftSqlServerSettings(MicrosoftSqlServerDataProviderSettings.BuilderImpl microsoftSqlServerSettings) {
            MicrosoftSqlServerDataProviderSettings oldValue = this.microsoftSqlServerSettings;
            this.microsoftSqlServerSettings = microsoftSqlServerSettings != null ? microsoftSqlServerSettings.build() : null;
            this.handleUnionValueChange(Type.MICROSOFT_SQL_SERVER_SETTINGS, oldValue, this.microsoftSqlServerSettings);
        }

        @Override
        public final Builder microsoftSqlServerSettings(MicrosoftSqlServerDataProviderSettings microsoftSqlServerSettings) {
            MicrosoftSqlServerDataProviderSettings oldValue = this.microsoftSqlServerSettings;
            this.microsoftSqlServerSettings = microsoftSqlServerSettings;
            this.handleUnionValueChange(Type.MICROSOFT_SQL_SERVER_SETTINGS, oldValue, this.microsoftSqlServerSettings);
            return this;
        }

        public DataProviderSettings build() {
            return new DataProviderSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataProviderSettings> {
        public Builder postgreSqlSettings(PostgreSqlDataProviderSettings var1);

        default public Builder postgreSqlSettings(Consumer<PostgreSqlDataProviderSettings.Builder> postgreSqlSettings) {
            return this.postgreSqlSettings((PostgreSqlDataProviderSettings)((PostgreSqlDataProviderSettings.Builder)PostgreSqlDataProviderSettings.builder().applyMutation(postgreSqlSettings)).build());
        }

        public Builder mySqlSettings(MySqlDataProviderSettings var1);

        default public Builder mySqlSettings(Consumer<MySqlDataProviderSettings.Builder> mySqlSettings) {
            return this.mySqlSettings((MySqlDataProviderSettings)((MySqlDataProviderSettings.Builder)MySqlDataProviderSettings.builder().applyMutation(mySqlSettings)).build());
        }

        public Builder oracleSettings(OracleDataProviderSettings var1);

        default public Builder oracleSettings(Consumer<OracleDataProviderSettings.Builder> oracleSettings) {
            return this.oracleSettings((OracleDataProviderSettings)((OracleDataProviderSettings.Builder)OracleDataProviderSettings.builder().applyMutation(oracleSettings)).build());
        }

        public Builder microsoftSqlServerSettings(MicrosoftSqlServerDataProviderSettings var1);

        default public Builder microsoftSqlServerSettings(Consumer<MicrosoftSqlServerDataProviderSettings.Builder> microsoftSqlServerSettings) {
            return this.microsoftSqlServerSettings((MicrosoftSqlServerDataProviderSettings)((MicrosoftSqlServerDataProviderSettings.Builder)MicrosoftSqlServerDataProviderSettings.builder().applyMutation(microsoftSqlServerSettings)).build());
        }
    }
}

