/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationAsyncClient;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse;

public class DescribeReplicationInstanceTaskLogsPublisher
implements SdkPublisher<DescribeReplicationInstanceTaskLogsResponse> {
    private final DatabaseMigrationAsyncClient client;
    private final DescribeReplicationInstanceTaskLogsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeReplicationInstanceTaskLogsPublisher(DatabaseMigrationAsyncClient client, DescribeReplicationInstanceTaskLogsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeReplicationInstanceTaskLogsPublisher(DatabaseMigrationAsyncClient client, DescribeReplicationInstanceTaskLogsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeReplicationInstanceTaskLogsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeReplicationInstanceTaskLogsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final DescribeReplicationInstanceTaskLogsPublisher resume(DescribeReplicationInstanceTaskLogsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeReplicationInstanceTaskLogsPublisher(this.client, (DescribeReplicationInstanceTaskLogsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeReplicationInstanceTaskLogsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeReplicationInstanceTaskLogsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeReplicationInstanceTaskLogsResponseFetcher
    implements AsyncPageFetcher<DescribeReplicationInstanceTaskLogsResponse> {
        private DescribeReplicationInstanceTaskLogsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReplicationInstanceTaskLogsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeReplicationInstanceTaskLogsResponse> nextPage(DescribeReplicationInstanceTaskLogsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReplicationInstanceTaskLogsPublisher.this.client.describeReplicationInstanceTaskLogs(DescribeReplicationInstanceTaskLogsPublisher.this.firstRequest);
            }
            return DescribeReplicationInstanceTaskLogsPublisher.this.client.describeReplicationInstanceTaskLogs((DescribeReplicationInstanceTaskLogsRequest)((Object)DescribeReplicationInstanceTaskLogsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

