/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.ReplicationInstance;
import software.amazon.awssdk.services.databasemigration.model.ReplicationInstanceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReplicationInstancesResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DescribeReplicationInstancesResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeReplicationInstancesResponse.getter(DescribeReplicationInstancesResponse::marker)).setter(DescribeReplicationInstancesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<ReplicationInstance>> REPLICATION_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplicationInstances").getter(DescribeReplicationInstancesResponse.getter(DescribeReplicationInstancesResponse::replicationInstances)).setter(DescribeReplicationInstancesResponse.setter(Builder::replicationInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicationInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, REPLICATION_INSTANCES_FIELD));
    private final String marker;
    private final List<ReplicationInstance> replicationInstances;

    private DescribeReplicationInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.replicationInstances = builder.replicationInstances;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasReplicationInstances() {
        return this.replicationInstances != null && !(this.replicationInstances instanceof SdkAutoConstructList);
    }

    public final List<ReplicationInstance> replicationInstances() {
        return this.replicationInstances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicationInstances() ? this.replicationInstances() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReplicationInstancesResponse)) {
            return false;
        }
        DescribeReplicationInstancesResponse other = (DescribeReplicationInstancesResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasReplicationInstances() == other.hasReplicationInstances() && Objects.equals(this.replicationInstances(), other.replicationInstances());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeReplicationInstancesResponse").add("Marker", (Object)this.marker()).add("ReplicationInstances", this.hasReplicationInstances() ? this.replicationInstances() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "ReplicationInstances": {
                return Optional.ofNullable(clazz.cast(this.replicationInstances()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReplicationInstancesResponse, T> g) {
        return obj -> g.apply((DescribeReplicationInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<ReplicationInstance> replicationInstances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReplicationInstancesResponse model) {
            super(model);
            this.marker(model.marker);
            this.replicationInstances(model.replicationInstances);
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<ReplicationInstance.Builder> getReplicationInstances() {
            List<ReplicationInstance.Builder> result = ReplicationInstanceListCopier.copyToBuilder(this.replicationInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicationInstances(Collection<ReplicationInstance.BuilderImpl> replicationInstances) {
            this.replicationInstances = ReplicationInstanceListCopier.copyFromBuilder(replicationInstances);
        }

        @Override
        public final Builder replicationInstances(Collection<ReplicationInstance> replicationInstances) {
            this.replicationInstances = ReplicationInstanceListCopier.copy(replicationInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationInstances(ReplicationInstance ... replicationInstances) {
            this.replicationInstances(Arrays.asList(replicationInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationInstances(Consumer<ReplicationInstance.Builder> ... replicationInstances) {
            this.replicationInstances(Stream.of(replicationInstances).map(c -> (ReplicationInstance)((ReplicationInstance.Builder)ReplicationInstance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeReplicationInstancesResponse build() {
            return new DescribeReplicationInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReplicationInstancesResponse> {
        public Builder marker(String var1);

        public Builder replicationInstances(Collection<ReplicationInstance> var1);

        public Builder replicationInstances(ReplicationInstance ... var1);

        public Builder replicationInstances(Consumer<ReplicationInstance.Builder> ... var1);
    }
}

